<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2018 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a ete copie vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------

$net2ftp_messages["%1\$s File"] = "%1\$s Dosyas";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(Not: Eer kendi alan adnza sahip deilseniz, bu balant almayabilir.)";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> ,<b>%2\$s</b>e yeniden adlandrlamyor";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> baarl bir ekilde <b>%2\$s</b>e yeniden adlandrld";
$net2ftp_messages["ARC archive"] = "ARC ariv paketi";
$net2ftp_messages["ARJ archive"] = "ARJ ariv paketi";
$net2ftp_messages["ASP script"] = "ASP yazlm";
$net2ftp_messages["Action"] = "Eylem";
$net2ftp_messages["Actions"] = "Eylemler";
$net2ftp_messages["Add another"] = "Bir bakasn ekle";
$net2ftp_messages["Adobe Acrobat document"] = "Adobe Acrobat belgesi";
$net2ftp_messages["Advanced"] = "Gelimi";
$net2ftp_messages["Advanced FTP functions"] = "Gelimi FTP ilevleri";
$net2ftp_messages["Advanced functions"] = "Gelimi ilevler";
$net2ftp_messages["Advanced login"] = "Advanced login";
$net2ftp_messages["All"] = "Tm";
$net2ftp_messages["All the selected directories and files have been processed."] = "Tm seili dosya ve dizinler ileme alnd.";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "Seili dizinlerin tm dosyalar ve alt dizinleri ayrca silinecek!";
$net2ftp_messages["Alternatively, use net2ftp's normal upload or upload-and-unzip functionality."] = "Alternatively, use net2ftp's normal upload or upload-and-unzip functionality.";
$net2ftp_messages["An error has occured"] = "Bir hata olutu";
$net2ftp_messages["Anonymous"] = "Anonim";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "Ariv paketi <b>%1\$s</b> ileme alnmad nk dosya uzants tannmad. u an sadece zip, tar, tgz ve gz ariv paketleri destekleniyor.";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "Archive contains filenames with ../ or ..\\ - aborting the extraction";
$net2ftp_messages["Archives"] = "Ariv paketleri";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Buraya girilen ariv paketleri alacaktr ve ierisindeki dosyalar FTP sunucusuna aktarlacaktr.";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "Bu dizin ve dosyalar silmek istediinizden emin misiniz?";
$net2ftp_messages["Ascending order"] = "Ykselen sralama";
$net2ftp_messages["Automatic"] = "Otomatik";
$net2ftp_messages["Back"] = "Geri";
$net2ftp_messages["Basic FTP login"] = "Basic FTP login";
$net2ftp_messages["Basic SSH login"] = "Basic SSH login";
$net2ftp_messages["Bitmap file"] = "Bitmap dosyas";
$net2ftp_messages["Bookmark"] = "Sk Kullanlanlar";
$net2ftp_messages["Calculate the size of the selected entries"] = "Seili girilerin boyutunu hesapla";
$net2ftp_messages["Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Cascading Style Sheet"] = "Cascading Style Sheet";
$net2ftp_messages["Case sensitive search"] = "Byk/kk harf hassas arama";
$net2ftp_messages["Changing the directory"] = "Dizini degistiriyor";                  //dizini: klasr
$net2ftp_messages["Changing to the directory %1\$s: "] = "Dizini %1\$s deitiriyor: ";
$net2ftp_messages["Character encoding: "] = "Karakter kodlamas: ";
$net2ftp_messages["Check the SSH server's public key fingerprint"] = "Check the SSH server's public key fingerprint";
$net2ftp_messages["Checking files"] = "Dosyalari denetliyor";
$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "Checking if the FTP module of PHP is installed: ";
$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "Web sunucunuzdaki dizinin iznini denetliyor: kk bir dosya /temp klasrne yazlacak ve sonra silinecek.";
$net2ftp_messages["Chmod"] = "Chmod";
$net2ftp_messages["Chmod also the files within this directory"] = "Bu dizin ierisindeki dosyalar da chmod";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "Bu dizin ierisindeki alt dizinleri de chmod";
$net2ftp_messages["Chmod directories and files"] = "Dizin ve dosyalar chmod";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "Seili girileri chmod (sadece Unix/Linux/BSD sunucularnda alyor)";
$net2ftp_messages["Choose"] = "Se";
$net2ftp_messages["Choose a directory"] = "Dizin se";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "Ykselen srada %1\$s ile sralamak iin tklayn";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "Alalan srada %1\$s ile sralamak iin tklayn";
$net2ftp_messages["Closing the file: "] = "Dosyay kapator: ";
$net2ftp_messages["Connecting to a test FTP server: "] = "Test FTP sunucusuna balanyor: ";
$net2ftp_messages["Connecting to the FTP server"] = "FTP sunucusuna baglaniyor";
$net2ftp_messages["Connecting to the FTP server: "] = "FTP sunucusuna balanyor: ";
$net2ftp_messages["Connection from net2ftp server to Google captcha server failed"] = "Connection from net2ftp server to Google captcha server failed";
$net2ftp_messages["Connection settings:"] = "Balant ayarlar:";
$net2ftp_messages["Continue"] = "Devam";
$net2ftp_messages["Copied file %1\$s"] = "Dosyay %1\$s kopyalad";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Dosyay <b>%1\$s</b> kopyalad";
$net2ftp_messages["Copy"] = "Kopyala";
$net2ftp_messages["Copy directories and files"] = "Dizin ve dosyalar kopyala";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "Dizini <b>%1\$s</b> una kopyala:";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "Dosyay <b>%1\$s</b> una kopyala:";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "symlink <b>%1\$s</b> una kopyala:";    //symlink: ?
$net2ftp_messages["Copy the selected entries"] = "Seili girileri kopyala";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "FTP sunucusuna net2ftp ykleyici yazilimini kopyaliyor";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Could not connect to SSH server"] = "Could not connect to SSH server";
$net2ftp_messages["Could not copy file %1\$s"] = "Dosyay %1\$s kopyalayamyor";
$net2ftp_messages["Could not create directory %1\$s"] = "Dizini %1\$s oluturamyor";
$net2ftp_messages["Could not generate a temporary file."] = "Geici bir dosya oluturamyor.";
$net2ftp_messages["Could not get fingerprint"] = "Could not get fingerprint";
$net2ftp_messages["Could not get public host key"] = "Could not get public host key";
$net2ftp_messages["Could not unzip entry %1\$s (error code %2\$s)"] = "Could not unzip entry %1\$s (error code %2\$s)";
$net2ftp_messages["Create a new file in directory %1\$s"] = "%1\$s dizininde yeni bir dosya olutur";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Hazr-yaplm ablon kullanarak kolayca bir websitesi oluturun";
$net2ftp_messages["Create new directories"] = "Yeni dizinler olutur";
$net2ftp_messages["Create the MySQL database tables"] = "MySQL veritaban tablolar olutur";
$net2ftp_messages["Created directory %1\$s"] = "Dizini %1\$s oluturuldu";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Hedef alt dizin <b>%1\$s</b> oluturuldu";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "FTP sunucusunda gecici dizin oluturuyor";           //dizin: klasr
$net2ftp_messages["Creating filename: "] = "Dosya ad oluturuyor: ";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "Gnlk snra ulat: dosya <b>%1\$s</b> aktarlamayacak";
$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "Gnlk snr at: bilgi aktaramayacaksnz";
$net2ftp_messages["Data transferred from this IP address today"] = "Data transferred from this IP address today";
$net2ftp_messages["Data transferred to this FTP server today"] = "Data transferred to this FTP server today";
$net2ftp_messages["Date from:"] = "Tarih den:";
$net2ftp_messages["Dear,"] = "Sayn,";
$net2ftp_messages["Decompressing archives and transferring files"] = "Arsiv paketini aciyor ve dosyalari aktariyor";
$net2ftp_messages["Default"] = "Varsaylan";
$net2ftp_messages["Delete"] = "Sil";
$net2ftp_messages["Delete directories and files"] = "Dizin ve dosyalar sil";
$net2ftp_messages["Delete the selected entries"] = "Seili girileri sil";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "Dosyay <b>%1\$s</b> sildi";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "Alt dizin <b>%1\$s</b> silindi";
$net2ftp_messages["Deleting the file: "] = "Dosyay siliyor: ";
$net2ftp_messages["Descending order"] = "Alalan sralama";
$net2ftp_messages["Details"] = "Detaylar";
$net2ftp_messages["Different target FTP server:"] = "Farkl hedef FTP sunucusu:";
$net2ftp_messages["Directories"] = "Dizinler";
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = " \' adn ieren dizinler doru bir ekilde gsterilemez. sadece silinebilir. Ltfen geri dnn ve bir baka alt dizin sein.";
$net2ftp_messages["Directory"] = "Dizin";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "Dizin <b>%1\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "Dizin <b>%1\$s</b> oluturamyor.";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "Dizin <b>%1\$s</b> baarl bir ekilde <b>%2\$s</b> e chmod yapld.";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "Dizin <b>%1\$s</b> baarl bir ekilde oluturuldu.";
$net2ftp_messages["Directory Tree"] = "Dizin aac";
$net2ftp_messages["Disabled"] = "Kapatld";    //disabled: ?
$net2ftp_messages["Double-click to go to a subdirectory:"] = "Alt dizine gitmek iin ift tklayn:";
$net2ftp_messages["Download"] = "ndir";
$net2ftp_messages["Download a zip file containing all selected entries"] = "Tm seili girileri ieren bir zip dosyas indir";
$net2ftp_messages["Download the file %1\$s"] = "Dosyay %1\$s indir";
$net2ftp_messages["Drag and drop one of the links below to the bookmarks bar"] = "Drag and drop one of the links below to the bookmarks bar";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Teknik problemler yznden e-posta <b>%1\$s</b>a gnderilemiyor.";
$net2ftp_messages["Edit"] = "Dzenle";
$net2ftp_messages["Edit the source code of file %1\$s"] = "Dosyann %1\$s kaynak kodunu dzenle";
$net2ftp_messages["Email is too long; please enter less than 255 characters."] = "Email is too long; please enter less than 255 characters.";
$net2ftp_messages["Email the zip file in attachment to:"] = "Zip dosyasn ek eklinde birisine, e-posta ile gnder:";
$net2ftp_messages["Empty logs"] = "Bo kaytlar";
$net2ftp_messages["Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21"] = "Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21";
$net2ftp_messages["Enter your email address"] = "Enter your email address";
$net2ftp_messages["Enter your password"] = "Enter your password";
$net2ftp_messages["Enter your username"] = "Enter your username";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Yasakl anahtar kelimeleri ieren giriler net2ftp kullanlarak ynetilemez. Bu, net2ftp yoluyla Paypal veya Ebay dolandrclnn yklenmesini nlemek iindir.";
$net2ftp_messages["Example"] = "rnek";
$net2ftp_messages["Executable"] = "Uygulama";
$net2ftp_messages["Execute %1\$s in a new window"] = "Yeni pencerede %1\$s gerekletir";
$net2ftp_messages["FTP mode"] = "FTP modu";
$net2ftp_messages["FTP server"] = "FTP sunucusu";
$net2ftp_messages["FTP server name is too long; please enter less than 255 characters."] = "FTP server name is too long; please enter less than 255 characters.";
$net2ftp_messages["FTP server port"] = "FTP sunucu port";
$net2ftp_messages["FTP server response:"] = "FTP sunucusu cevab:";
$net2ftp_messages["File"] = "Dosya";
$net2ftp_messages["File <b>%1\$s</b>"] = "Dosya <b>%1\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "Dosya <b>%1\$s</b> tanamyor";
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "Dosya <b>%1\$s</b> FTP sunucusuna aktarlamyor";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "Dosya <b>%1\$s</b> FTP sunucusuna, FTP <b>%2\$s</b> modu kullanarak aktarld";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "Dosya <b>%1\$s</b> TAMAM";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "Dosya <b>%1\$s</b> yasakl anahtar szck ieriyor. Bu dosya yklenilmeyecek.";
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "Dosya <b>%1\$s</b> ok byk. Bu dosya yklenilmeyecek.";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "<b>%1\$s</b> Dosya baarl bir ekilde <b>%2\$s</b>e chmod yapld";
$net2ftp_messages["File: "] = "Dosya: ";
$net2ftp_messages["Files"] = "Dosyalar";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Buraya girilen dosyalar FTP sunucusuna aktarlacaktr.";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "ok byk olan dosyalar, indirilemez, yklenemez, kopyalanamaz, tanamaz, aranamaz, ariv paketine eklenemez, ariv paketinden kartlamaz, grntlemez veya dzenlemez; sadece yeniden adlandrlabilir, izinleri deitirilebilir veya silinebilir.";
$net2ftp_messages["Find files which contain a particular word"] = "Belirli bir szc ieren dosyalar bul";
$net2ftp_messages["Fingerprint"] = "Fingerprint";
$net2ftp_messages["Follow symlink %1\$s"] = "Symlink %1\$s takip et";
$net2ftp_messages["Font file"] = "Font dosyas";
$net2ftp_messages["Forums"] = "Forumlar";
$net2ftp_messages["GIF file"] = "GIF dosyas";
$net2ftp_messages["GIMP file"] = "GIMP dosyas";
$net2ftp_messages["GZ archive"] = "GZ ariv paketi";
$net2ftp_messages["Get fingerprint"] = "Get fingerprint";
$net2ftp_messages["Get the SSH server's public key fingerprint before logging in to verify the server's identity"] = "Get the SSH server's public key fingerprint before logging in to verify the server's identity";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "FTP sunucusundan arsiv paketini aliyor %1\$s - %2\$s";
$net2ftp_messages["Getting fingerprint, please wait..."] = "Getting fingerprint, please wait...";
$net2ftp_messages["Getting the FTP server system type: "] = "FTP sunucusu sistem trn alyor: ";
$net2ftp_messages["Getting the FTP system type"] = "FTP sistem trn aliyor";
$net2ftp_messages["Getting the current directory"] = "Gncel dizini aliyor";          //dizini: klasr
$net2ftp_messages["Getting the list of directories and files"] = "Dosya ve dizinlerin listesini aliyor";           //dizinlerin: klasrlerin
$net2ftp_messages["Getting the raw list of directories and files: "] = "Dosya ve dizinlerin ham listesini alyor: ";
$net2ftp_messages["Go"] = "Git";
$net2ftp_messages["Go back"] = "Geri dn";
$net2ftp_messages["Go to the advanced functions"] = "Gelimi ilevlere git";
$net2ftp_messages["Go to the login page"] = "Giri sayfasna git";
$net2ftp_messages["Go to the parent directory"] = "Ana dizine git";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "Alt dizine %1\$s git";
$net2ftp_messages["Group"] = "Grup";
$net2ftp_messages["HTML file"] = "HTML dosyas";
$net2ftp_messages["HTML templates"] = "HTML ablonlar";
$net2ftp_messages["Help"] = "Yardm";
$net2ftp_messages["Help Guide"] = "Yardm Rehberi";
$net2ftp_messages["IP address: "] = "IP adres: ";
$net2ftp_messages["Icons"] = "Ikonlar";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Eer hedef dosya zaten varsa, zerine yazlacaktr";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "Eer bunun hakknda hibir ey bilmiyorsanz ya da bu kiiye gvenmiyorsanz, ltfen ekteki zip ariv paketi dosyasn amadan bu e-postay silin.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "Eer snrsz kullanma ihtiya duyuyorsanz, ltfen net2ftpyi kendi web sunucunuza ykleyin.";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "Eer gerekten net2ftp  nin daha uzun sre alan byk ilemleri ele alabilmesi iin, net2ftp yi kendi sunucunuza yklemeyi dnn.";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "Eer dosyalar bir baka FTP sunucusuna kopyalamak istiyorsanz, giri bilginizi girin.";
$net2ftp_messages["Image"] = "Resim";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "Herkesin web sunucusunu adil bir ekilde kullanmn garanti etmek iin, bilgi aktarm hacmi ve yazlm uygulama sresi, kullanc bana ve gnlk olarak snrlandrlmtr. Bir kez bu snra ulaldnda, FTP sunucusunu hala gezebilir fakat ondan/ona bilgi aktaramazsnz.";
$net2ftp_messages["In order to run it, click on the link below."] = "altrmak iin, aadaki balantya tklayn.";
$net2ftp_messages["Information about the sender: "] = "Gnderen hakknda bilgiler: ";
$net2ftp_messages["Initial directory"] = "lk dizin";
$net2ftp_messages["Install"] = "Kur";
$net2ftp_messages["Install software packages"] = "Yazlm paketlerini ykle";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Yazlm paketlerini ykle (web sunucusunda PHP gerektirir)";
$net2ftp_messages["JPEG file"] = "JPEG dosyas";
$net2ftp_messages["Java Upload"] = "Java ile Ykle";
$net2ftp_messages["Java source file"] = "Java kaynak dosyas";
$net2ftp_messages["JavaScript file"] = "JavaScript dosyas";
$net2ftp_messages["Language:"] = "Dil:";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Eer dosyalar, ayn FTP sunucusuna kopyalamak istiyorsanz, bo brakn.";
$net2ftp_messages["License"] = "Lisans";
$net2ftp_messages["Line"] = "Satr";
$net2ftp_messages["List"] = "Liste";
$net2ftp_messages["List of commands:"] = "Komutlarn listesi:";
$net2ftp_messages["Logging"] = "Giriyor";
$net2ftp_messages["Logging into the FTP server"] = "FTP sunucusuna giris yapiyor";
$net2ftp_messages["Logging into the FTP server: "] = "FTP sunucusuna giri yapyor: ";
$net2ftp_messages["Logging out of the FTP server"] = "FTP sunucusundan cikis yapiyor";
$net2ftp_messages["Login"] = "Giri";
$net2ftp_messages["Login!"] = "Giri!";
$net2ftp_messages["Logout"] = "k";
$net2ftp_messages["MOV movie file"] = "MOV film dosyas";
$net2ftp_messages["MPEG movie file"] = "MPEG film dosyas";
$net2ftp_messages["MS Office - Access database"] = "MS Ofis - Access veritaban";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Ofis - Excel izelgesi";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Ofis - PowerPoint sunumu";
$net2ftp_messages["MS Office - Project file"] = "MS Ofis - Project dosyas";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Ofis - Visio izimi";
$net2ftp_messages["MS Office - Word document"] = "MS Ofis - Word belgesi";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "%1\$s dizininde yeni bir alt dizin yap";
$net2ftp_messages["Message of the sender: "] = "Gnderenin iletisi: ";
$net2ftp_messages["Mobile"] = "Mobile";
$net2ftp_messages["Mod Time"] = "Mod Zaman";
$net2ftp_messages["Move"] = "Ta";
$net2ftp_messages["Move directories and files"] = "Dizin ve dosyalar ta";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "Dizini <b>%1\$s</b> una ta:";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "Dosyay <b>%1\$s</b> una ta:";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "symlink <b>%1\$s</b> una ta:";       //symlink: ?
$net2ftp_messages["Move the selected entries"] = "Seili girileri ta";
$net2ftp_messages["Moved directory <b>%1\$s</b>"] = "Moved directory <b>%1\$s</b>";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "Dosya <b>%1\$s</b> tand";
$net2ftp_messages["MySQL database"] = "MySQL veritaban";
$net2ftp_messages["MySQL password"] = "MySQL ifresi";
$net2ftp_messages["MySQL password length"] = "MySQL ifre uzunluu";
$net2ftp_messages["MySQL server"] = "MySQL sunucusu";
$net2ftp_messages["MySQL username"] = "MySQL kullanc ad";
$net2ftp_messages["Name"] = "Ad";
$net2ftp_messages["New dir"] = "Yeni Dizin";
$net2ftp_messages["New directory name:"] = "Yeni dizin ad:";
$net2ftp_messages["New file"] = "Yeni Dosya";
$net2ftp_messages["New file name: "] = "Yeni dosya ad: ";
$net2ftp_messages["New name: "] = "Yeni ad: ";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Zip ariv paketi dosyasn amazsanz, ierisindeki dosyalarn bilgisayarnza zarar veremeyeceine dikkat edin.";   //note: ?
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "Dosya gndermenin anonim olmadna dikkat edin: Gnderme zamannza ek olarak, IP adresiniz e-postaya eklenecek.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "Not: bu bilgisayarn dier kullanclar,taraycnn Geri dmesine tklayabilir ve FTP sunucusuna ulaabilir.";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Not: ierisine herhangi bir ey kopyalanmadan nce, hedef dizin nceden var olmal.";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "Not: bu sk kullanlanlar kullandnz zaman, pop alan pencere size kullanc adnz ve ifrenizi soracak.";
$net2ftp_messages["OK"] = "TAMAM";
$net2ftp_messages["OK. Filename: %1\$s"] = "TAMAM. Dosya ad: %1\$s";
$net2ftp_messages["Old name: "] = "Eski ad: ";
$net2ftp_messages["One click access (net2ftp won't ask for a password - less safe)"] = "One click access (net2ftp won't ask for a password - less safe)";
$net2ftp_messages["Open"] = "A";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 izelgesi";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Calc 6.0 ablonu";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Draw 6.0 belgesi";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Draw 6.0 ablonu";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 sunumu";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Impress 6.0 ablonu";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Math 6.0 belgesi";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Writer 6.0 belgesi";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Writer 6.0 evrensel belge";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Writer 6.0 ablonu";
$net2ftp_messages["Opening the file in write mode: "] = "Dosyay yazma modunda ayor: ";
$net2ftp_messages["Owner"] = "sahip";
$net2ftp_messages["PHP Source"] = "PHP Kaynak";
$net2ftp_messages["PHP script"] = "PHP yazlm";
$net2ftp_messages["PNG file"] = "PNG dosyas";
$net2ftp_messages["Parsing the file"] = "Dosyayi zmlyor";
$net2ftp_messages["Parsing the list of directories and files"] = "Dosya ve dizinlerin listesini czmlyor";       //parsing: ?
$net2ftp_messages["Passive mode"] = "Pasif mod";
$net2ftp_messages["Password"] = "ifre";
$net2ftp_messages["Password length"] = "ifre uzunluu";
$net2ftp_messages["Perms"] = "zinler";
$net2ftp_messages["Please agree to all privacy policies."] = "Please agree to all privacy policies.";
$net2ftp_messages["Please enter a password."] = "Ltfen bir ifre girin.";
$net2ftp_messages["Please enter a username."] = "Ltfen bir kullanc ad girin.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Ltfen \"kimden\" metin kutusuna yl-ay-gn biiminde geerli bir tarih girin.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Ltfen \"kime\" metin kutusuna yl-ay-gn biiminde geerli bir tarih girin.";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "Ltfen \"kimden\" metin kutusuna geerli bir dosya boyutu girin, rnein 0.";      //from: ?
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "Ltfen \"kime\" metin kutusuna geerli bir dosya boyutu girin, rnein 500000.";
$net2ftp_messages["Please enter a valid filename."] = "Ltfen geerli bir dosya ad girin.";
$net2ftp_messages["Please enter a valid search word or phrase."] = "Ltfen geerli bir arama szc ya da sz bei girin.";
$net2ftp_messages["Please enter an FTP server."] = "Ltfen bir FTP sunucusu girin.";
$net2ftp_messages["Please enter your Administrator username and password."] = "Ltfen ynetici kullanc adnz ve ifrenizi girin.";
$net2ftp_messages["Please enter your MySQL settings:"] = "Ltfen MySQL ayarlarnz girin:";
$net2ftp_messages["Please enter your email address as identifier to give you the right of access and erasure:"] = "Please enter your email address as identifier to give you the right of access and erasure:";
$net2ftp_messages["Please enter your email address."] = "Please enter your email address.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Ltfen FTP sunucusu iin kullanc adnz ve ifrenizi girin<b>%1\$s</b>.";
$net2ftp_messages["Please specify a filename"] = "Ltfen bir dosya ad belirtin";
$net2ftp_messages["Please wait..."] = "Ltfen bekleyin...";
$net2ftp_messages["Powered by"] = "Katklaryla";
$net2ftp_messages["Printing the list of directories and files"] = "Dosya ve dizinlerin listesini yazdiriyor";      //dizinlerin: klasrlerin
$net2ftp_messages["Printing the result"] = "Sonular yazdryor";
$net2ftp_messages["Privacy notices"] = "Privacy notices";
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "Ariv paketini %1\$s ileme alyor: <b>%2\$s</b>";
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "<b>%1\$s</b> dizinini ileme alyor";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "<b>%1\$s</b> dizin ierisindeki girileri ileme alyor:";
$net2ftp_messages["Processing entry %1\$s"] = "Girisi isleme aliyor %1\$s";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "Dizinin <b>%1\$s</b> ileme alnmas tamamland";
$net2ftp_messages["Processing the entries"] = "Girisi isleme aliyor";
$net2ftp_messages["Protocol"] = "Protocol";
$net2ftp_messages["Quicktime movie file"] = "Quicktime film dosyas";
$net2ftp_messages["RPM"] = "RPM";
$net2ftp_messages["Reading the file"] = "Dosyayi okuyor";
$net2ftp_messages["Real movie file"] = "Real film dosyas";
$net2ftp_messages["Refresh"] = "Yenile";
$net2ftp_messages["Rename"] = "Yeniden Adlandr";
$net2ftp_messages["Rename directories and files"] = "Dosya ve dizileri yeniden adlandr";
$net2ftp_messages["Rename the selected entries"] = "Seili girileri yeniden adlandr";
$net2ftp_messages["Requested files"] = "stenilen dosyalar";
$net2ftp_messages["Restrict the search to:"] = "Aramay una kstla:";
$net2ftp_messages["Restrictions:"] = "Kstlamalar:";
$net2ftp_messages["Results:"] = "Sonular:";
$net2ftp_messages["Right-click on one of the links below and choose \"Add to Favorites...\""] = "Right-click on one of the links below and choose \"Add to Favorites...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark This Link...\""] = "Right-click on one of the links below and choose \"Bookmark This Link...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark link...\""] = "Right-click on one of the links below and choose \"Bookmark link...\"";
$net2ftp_messages["Right-click on one the links below and choose \"Add Link to Bookmarks...\""] = "Right-click on one the links below and choose \"Add Link to Bookmarks...\"";
$net2ftp_messages["SSH fingerprint"] = "SSH fingerprint";
$net2ftp_messages["SSH server"] = "SSH server";
$net2ftp_messages["Save"] = "Kaydet";
$net2ftp_messages["Save the zip file on the FTP server as:"] = "FTP sunucusunda zip dosyas olarak kaydet:";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";
$net2ftp_messages["Script finished in %1\$s seconds"] = "Yazilim %1\$s saniyede bitti";
$net2ftp_messages["Script halted"] = "Yazlm durdu";
$net2ftp_messages["Search"] = "Arama";
$net2ftp_messages["Search directories and files"] = "Dosya ve dizinleri ara";
$net2ftp_messages["Search for a word or phrase"] = "Kelime ya da sz bei ara";
$net2ftp_messages["Search results"] = "Arama sonular";
$net2ftp_messages["Searching the files..."] = "Dosyalari ariyor...";
$net2ftp_messages["Select the directory %1\$s"] = "Dizini %1\$s se";
$net2ftp_messages["Select the file %1\$s"] = "Dosyay %1\$s se";
$net2ftp_messages["Select the symlink %1\$s"] = "Symlink %1\$s se";
$net2ftp_messages["Send arbitrary FTP commands"] = "Rastgele FTP komutlar gnder";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "FTP sunucusuna rastgele FTP komutlar gnder";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "FTP komutu gnderiyor %1\$s - %2\$s";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Bu websitesine yklenen net2ftp uygulamas yoluyla gnderildi: ";
$net2ftp_messages["Set all permissions"] = "Tm izinleri ayarla";
$net2ftp_messages["Set all targetdirectories"] = "Tm hedef dizinleri ayarla";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "Diznin <b>%1\$s</b> izinlerini una ayarla: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "Dosyann <b>%1\$s</b> izinlerini una ayarla: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "symlink <b>%1\$s</b> izinlerini una ayarla: ";      //smlink: ?
$net2ftp_messages["Setting the passive mode"] = "Pasif moda geciyor";                 //geiyor: ayarlyor
$net2ftp_messages["Setting the passive mode: "] = "Pasif moda geiyor: ";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Gecici diznin iznini ayarliyor";
$net2ftp_messages["Settings used:"] = "Kullanlan ayarlar:";
$net2ftp_messages["Setup MySQL tables"] = "MySQL tablolarn kur";
$net2ftp_messages["Shell script"] = "Shell yazlm";
$net2ftp_messages["Shockwave file"] = "Shockwave dosyas";
$net2ftp_messages["Shockwave flash file"] = "Shockwave fla dosyas";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Eer bu balant doru deilse, URL yi web taraycnza elinizle girin.";
$net2ftp_messages["Size"] = "Boyut";
$net2ftp_messages["Size of selected directories and files"] = "Seili dizin ve dosyalarn boyutu";
$net2ftp_messages["Skin:"] = "Kaplama:";
$net2ftp_messages["Some additional comments to add in the email:"] = "E-postaya eklenecek baz ek yorumlar:";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Birisi bu e-posta hesabna (%1\$s) ekteki dosyann gnderilemsini istedi.";
$net2ftp_messages["Standard"] = "Standard";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x zm";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - StarChart 5.x belgesi";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - StarDraw 5.x belgesi";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x sunumu";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress Packed 5.x dosyas";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x posta dosyas";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - StarMath 5.x belgesi";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - StarWriter 5.x belgesi";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - StarWriter 5.x evrensel belge";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "Durum: <b>Bu sayfa kaydedilemiyor</b>";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "Durum: <b>%1\$s</b>de %2\$s modu kullanlarak kaydedildi";
$net2ftp_messages["Status: This file has not yet been saved"] = "Durum: Bu sayfa henz kaydedilmedi";
$net2ftp_messages["Submit"] = "Gnder";
$net2ftp_messages["Symlink"] = "Symlink";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "Symlink <b>%1\$s</b>";
$net2ftp_messages["Symlinks"] = "Symlinks";
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>"] = "Szdizim vurgulama <a href=\"http://luminous.asgaard.co.uk\">Luminous</a> ile glendirilmitir";
$net2ftp_messages["TAR archive"] = "TAR ariv paketi";
$net2ftp_messages["TIF file"] = "TIF dosyas";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "Table net2ftp_log_access contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "Table net2ftp_log_access could not be updated.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "net2ftp_log_consumption_ftpserver tablosu ift giriler ieriyor.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "net2ftp_log_consumption_ftpserver tablosu ift dizeler ieriyor.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "net2ftp_log_consumption_ftpserver tablosu gncellenemiyor.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "net2ftp_log_consumption_ipaddress tablosu contains ift giriler ieriyor.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "net2ftp_log_consumption_ipaddress tablosu ift dizeler ieriyor.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "net2ftp_log_consumption_ipaddress tablosu gncellenemiyor.";
$net2ftp_messages["Table net2ftp_log_status contains duplicate entries."] = "Table net2ftp_log_status contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_status could not be updated."] = "Table net2ftp_log_status could not be updated.";
$net2ftp_messages["Target directory:"] = "Hedef dizin:";
$net2ftp_messages["Target name:"] = "Hedef ad:";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "Net2ftp liste zmleme kurallarn test et";
$net2ftp_messages["Testing the FTP functions"] = "FTP ilevlerini test ediyor";
$net2ftp_messages["Text file"] = "Metin dosyas";
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />"] = "The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />";
$net2ftp_messages["The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />"] = "The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "FTP sunucusu <b>%1\$s</b> yasakl FTP sunucular listesinde.";
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "FTP sunucusu <b>%1\$s</b> izin verilen FTP sunucular listesinde deil.";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "FTP sunucusu portu %1\$s kullanlmayabilir.";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP aktarm modu (ASCII veya BINARY) dosya uzantsna bal olarak ,otomatik belirlenecektir";
$net2ftp_messages["The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />"] = "The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "chmod says <b>%1\$s</b> 000-777 aralnn dndadr. Ltfen tekrar deneyin.";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "<b>%1\$s</b> dizini yasakl bir anahtar kelime ieriyor, tamay iptal ediyor";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword,bu yzden bu dizin atlanlacak";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "Dizin <b>%1\$s</b> seilemiyor - bu dizini grntleyebilmek iin yeterli haklara sahip olmayabilirsiniz veya o, var deil.";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "Dizin <b>%1\$s</b> seilemiyor,bu yzden bu dizin atlanlacak";
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "Dizin <b>%1\$s</b> yok veya seilemiyor, bu yzden yerine <b>%2\$s</b> dizini gsteriliyor.";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "Girdiiniz e-posta adresi (%1\$s) geerli gzkmyor.<br />Ltfen <b>kullancad@alanad.com</b> biiminde bir adres girin";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "Dosya <b>%1\$s</b> yasakl anahtar szck ieriyor, tamay iptal ediyor";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "Dosya <b>%1\$s</b> yasakl anahtar szck ieriyor, bu yzden bu dosya atlanlacak";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "Dosya <b>%1\$s</b> kopyalayabilmek iin ok byk, bu yzden bu dosya atlanlacak";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "Dosya <b>%1\$s</b> tamak iin ok byk, tamay iptal ediyor";
$net2ftp_messages["The file is too big to be transferred"] = "Dosya aktarabilmek iin ok byk";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "En son srm bilgisi, net2ftp.com sunucusundan alnamyor. Taraycnzn net2ftp.com sunucusundan kk bir dosya yklemesini engelleyebilen gvenlik ayarlarn denetleyin.";   //retrieved: ?
$net2ftp_messages["The log tables could not be copied."] = "The log tables could not be copied.";
$net2ftp_messages["The log tables could not be renamed."] = "The log tables could not be renamed.";
$net2ftp_messages["The log tables were copied successfully."] = "The log tables were copied successfully.";
$net2ftp_messages["The log tables were renamed successfully."] = "The log tables were renamed successfully.";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Maksimum uygulama sresi <b>%1\$s saniye</b>dir";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>"] = "The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>";
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "Net2ftp ykleyici yazlm FTP sunucusuna kopyaland.";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "Yeni dizinler, <b>%1\$s</b>de oluturulacaktr.";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "Yeni ad yasakl anahtar kelime ieremez. Bu giri, <b>%1\$s</b>e yeniden adlandrlmad";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "Yeni ad nokta ieremez. Bu giri, <b>%1\$s</b>e yeniden adlandrlmad";
$net2ftp_messages["The number of files which were skipped is:"] = "Atlanlan dosyalarn says:";
$net2ftp_messages["The oldest log table could not be dropped."] = "The oldest log table could not be dropped.";
$net2ftp_messages["The oldest log table was dropped successfully."] = "The oldest log table was dropped successfully.";
$net2ftp_messages["The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment)."] = "The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment).";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "Tablo <b>%1\$s</b> boaltlamyor.";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "Tablo <b>%1\$s</b> onarlamyor.";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "Tablo <b>%1\$s</b> baarl bir ekilde boaltld.";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "Tablo <b>%1\$s</b> baarl bir ekilde onarld.";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "<b>%1\$s</b> hedef dizini <b>%2\$s</b> kaynak dizininin ayns veya bir alt dizini , bu yzden bu dizin atlanlacak";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "Dosya iin hedef <b>%1\$s</b> kaynan ayns, bu yzden bu dosya atlanlacak";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "Net2ftp ile gerekletirmek istediiniz ilem izin verilen %1\$s saniyeden daha fazla srd ve bu nedenle ilem durduruldu.";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "Seili dizin ve dosyalarn ald toplam boyut:";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "<b>consumption_ipaddress_datatransfer</b> deikeni saysal deil.";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "Szck <b>%1\$s</b>, aadaki dosyalarda bulundu:";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "Szck <b>%1\$s</b>, seili alt dizinlerde ve dosyalarda bulunamad.";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "Zip ariv paketi dosyas, FTP sunucusuna <b>%1\$s</b> olarak kaydedildi";
$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "Zip arivi paketi, <b>%1\$s</b>e gnderildi.";
$net2ftp_messages["This SQL query is going to be executed:"] = "Bu SQL sorgusu gerekletirilecek:";
$net2ftp_messages["This file is not accessible from the web"] = "Bu sayfaya webten ulalabilir deil";
$net2ftp_messages["This folder is empty"] = "Bu klasr bo";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "Bu ilev bu websitenin Yneticisi tarafndan kapatld.";    //disabled: ?
$net2ftp_messages["This function is available on PHP 5 only"] = "Bu ilev sadece PHP 5 de mmkn";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "Bu yazlm, web sunucunuzda alr ve yklenebilmesi iin PHP gerektirir.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "Bu sre snr, web sunucusunu herkes tarafndan adil kullanmn garantiler.";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "Net2ftp nin bu srm gncel.";
$net2ftp_messages["Time of sending: "] = "Gnderme zaman: ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "Bunu nlemek iin, tm tarayc pencerelerini kapatmalsnz.";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "Resmi kaydetmek iin, zerine sa tklayn ve 'Resmi Farkl Kaydet...'i sein";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "Sradan bir hedef dizin ayarlamak iin, yukardaki metin kutusuna hedef dizini girin ve \"Tm hedef dizinleri ayarla\"dmesine tklayn.";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\"";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "Tm izinleri ayn deere ayarlamak iin, yukardaki o izinleri girin ve \"Tm izinleri ayarla\" dmesine tklayn";
$net2ftp_messages["To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now."] = "To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now.";
$net2ftp_messages["Transferring files to the FTP server"] = "FTP sunucusuna dosyalari aktariyor";
$net2ftp_messages["Transform selected entries: "] = "Seili girileri dntr: ";
$net2ftp_messages["Troubleshoot an FTP server"] = "FTP sunucusunun sorunlarn gider";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "Bu websunucusunda net2ftp nin sorunlarn gider";
$net2ftp_messages["Troubleshoot your net2ftp installation"] = "Net2ftp yklemenizin sorunu zn";
$net2ftp_messages["Troubleshooting functions"] = "levlerin sorunlarn gider";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "leminizi daha kk ilemlere blmeye aln: dosyalarnzn seimini kstlayn ve en byk dosyalar atlayn.";
$net2ftp_messages["Two click access (net2ftp will ask for a password - safer)"] = "Two click access (net2ftp will ask for a password - safer)";
$net2ftp_messages["Type"] = "Tr";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Geici dosyann idaresini kapatamyor";    //handle: ?
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP sunucusuna <b>%1\$s</b> portunda <b>%2\$s</b> balanamyor.<br /><br />FTP sunucusunun adresinin bu olduundan emin misiniz? Bu sklkla HTTP (web) sunucusununkinden farkldr. Ltfen yardm iin ISS yardm masanzla ya da sistem yneticinizle iletiim kurun.<br />";
$net2ftp_messages["Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "MySQL veritabanna balanamyor. Ltfen MySQL veritaban ayarlarnz net2ftp'nin ayar dosyas settings.inc.php de denetleyin.";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "Dosyay <b>%1\$s</b> kopyalayamyor";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "Yerel dosyay, uzaktaki dosyaya <b>%1\$s</b> FTP <b>%2\$s</b> modunu kullanarak kopyalayamyor";
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "Uzaktaki dosyay <b>%1\$s</b> yerel dosyaya  FTP <b>%2\$s</b> modunu kullanarak kopyalayamyor";
$net2ftp_messages["Unable to create a temporary directory (too many tries)"] = "Unable to create a temporary directory (too many tries)";
$net2ftp_messages["Unable to create a temporary directory because (parent directory is not writeable)"] = "Unable to create a temporary directory because (parent directory is not writeable)";
$net2ftp_messages["Unable to create a temporary directory because (unvalid parent directory)"] = "Unable to create a temporary directory because (unvalid parent directory)";
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "<b>%1\$s</b> dizini oluturamyor";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "<b>%1\$s</b> alt dizini oluturamyor. nceden var olabilir. Kopyalama/tama ilemine devam ediyor...";
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "Geici dosya oluturamyor. %1\$s dizininin izinlerini denetleyin.";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "Dosyay <b>%1\$s</b> silemiyor";
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "<b>%1\$s</b> dizini silemiyor";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "<b>%1\$s</b> dosyay silemiyor";
$net2ftp_messages["Unable to delete the local file"] = "Yerel dosyay silemiyor";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "Alt dizini <b>%1\$s</b> silemiyor - bo olmayabilir";
$net2ftp_messages["Unable to delete the temporary directory"] = "Geici dizini silemiyor";
$net2ftp_messages["Unable to delete the temporary file"] = "Geici dosyay silemiyor";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Geici dosyay %1\$s silemiyor";
$net2ftp_messages["Unable to determine your IP address."] = "IP adresinizi belirleyemiyor.";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "Site komutunu <b>%1\$s</b> gerekletiremiyor";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "Site komutunu <b>%1\$s</b> gerekletiremiyor. CHMOD komutunun, Windows FTP sunucularnda deil de sadece Unix FTP sunucularnda mmkn olduuna dikkat edin.";    //note: ?
$net2ftp_messages["Unable to execute the SQL query."] = "SQL sorgusunu gerekletiremiyor.";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Ariv paketinden dosya ve dizinleri kartamyor";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "FTP sunucusundan ariv paketini alamyor <b>%1\$s</b>";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "FTP sunucusundan <b>%1\$s</b> dosyasn alamyor ve <b>%2\$s</b> geici dosya olarak kaydedemiyor.<br /> %3\$s dizininin izinlerini denetleyin.<br />";
$net2ftp_messages["Unable to get the list of packages"] = "Paketlerin listesini alamyor";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP sunucusuna <b>%1\$s</b> kullanc adyla <b>%2\$s</b> giri yapamyor.<br /><br />Kullanc adnzn ve ifrenizin doru olduundan emin misiniz? Ltfen yardm iin ISS yardm masanzla ya da sistem yneticinizle iletiim kurun.<br />";
$net2ftp_messages["Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to move the directory <b>%1\$s</b>"] = "Unable to move the directory <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>"] = "Unable to move the file <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Dosyay <b>%1\$s</b> tayamyor, tamay iptal ediyor";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "Yklenen dosyay temp dizinine tayamyor.<br /><br />Bu websitesinin yneticisi net2ftp nin temp dizinini <b>777 chmod</b> yapmal.";
$net2ftp_messages["Unable to open the system log."] = "Unable to open the system log.";
$net2ftp_messages["Unable to open the template file"] = "ablon dosyasn aamyor";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Geici dosyay aamyor. %1\$s dizininin izinlerini denetleyin.";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "FTP sunucusuna <b>%1\$s</b> dosyasn yerletiremiyor.<br />Dizinde yazma iznine sahip olamayabilirsiniz.";
$net2ftp_messages["Unable to read the template file"] = "ablon dosyasn okuyamyor";
$net2ftp_messages["Unable to read the temporary file"] = "Geici dosyay okuyamyor";
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "<b>%1\$s</b> dosya ya da dizinini <b>%2\$s</b>e yeniden adlandramyor";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "MySQL veritabann seemiyor. Ltfen MySQL veritaban ayarlarnz net2ftp'nin ayar dosyas settings.inc.php de denetleyin.";
$net2ftp_messages["Unable to send the file to the browser"] = "Taraycya dosyay gnderemiyor";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "FTP sunucusunda <b>%1\$s</b> pasif moda geemiyor.";    //switch: ?
$net2ftp_messages["Unable to write a message to the system log."] = "Unable to write a message to the system log.";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "<b>%1\$s</b> geici dosyaya diziyi yazamyor.<br />%1\$s dizininin izinlerini denetleyin.";
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "Beklenmeyen durum dizisi: %1\$s. kyor.";
$net2ftp_messages["Unrecognized FTP output"] = "Tannmayan FTP sonucu";
$net2ftp_messages["Unzip"] = "Ariv a";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Ariv paketlerini <b>%1\$s</b> una a:";
$net2ftp_messages["Unzip archives"] = "Ariv paketlerini a";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "FTP sunucusundaki seili ariv paketlerini a";
$net2ftp_messages["Up"] = "Yukar";
$net2ftp_messages["Update"] = "Gncelle";
$net2ftp_messages["Upload"] = "Ykle";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "Dosyann %1\$s yeni srmn ykle ve deiiklikleri birletir";   //mere: ?
$net2ftp_messages["Upload directories and files using a Java applet"] = "Java aplet kullanarak dizin ve dosyalar ykle";
$net2ftp_messages["Upload files and archives"] = "Dosyalar ve ariv paketlerini ykle";
$net2ftp_messages["Upload more files and archives"] = "Daha fazla ariv paketi ve dosya ykle";
$net2ftp_messages["Upload new files in directory %1\$s"] = "%1\$s dizinine yeni dosya ykle";
$net2ftp_messages["Upload to directory:"] = "Dizine ykle:";    //dizine: klasre
$net2ftp_messages["Username"] = "Kullanc ad";
$net2ftp_messages["Username is too long; please enter less than 255 characters."] = "Username is too long; please enter less than 255 characters.";
$net2ftp_messages["Version information"] = "Srm bilgisi";
$net2ftp_messages["View"] = "Grntle";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Macromedia ShockWave Fla filmini gster %1\$s";
$net2ftp_messages["View file %1\$s"] = "Dosyay gster %1\$s";
$net2ftp_messages["View image %1\$s"] = "Resmi %1\$s grntle";
$net2ftp_messages["View logs"] = "Kaytlar grntle";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "HTTP web sunucunuzdan %1\$s dosyay grntle";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Dosyann %1\$s vurgulanm kaynak kodunu grntle";
$net2ftp_messages["WAV sound file"] = "WAV ses dosyas";
$net2ftp_messages["Webmaster's email: "] = "Web sahibi'nin e-postas: ";
$net2ftp_messages["Writing some text to the file: "] = "Dosyaya herhangi bir metin yazor : ";
$net2ftp_messages["Wrong username or password. Please try again."] = "Yanl kullanc ad veya ifre. Ltfen tekrar deneyin.";
$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "Zip dosyas iin bir dosya ad girmediniz. Geri dnn ve bir dosya ad girin.";
$net2ftp_messages["You did not enter your Administrator username or password."] = "Ynetici kullanc adnz veya ifrenizi girmediniz.";
$net2ftp_messages["You did not provide any file to upload."] = "Yklemek iin herhangi bir dosya salamadnz.";
$net2ftp_messages["You did not provide any text to send by email!"] = "E-postayla gndermek iin herhangi bir metin salamadnz!";
$net2ftp_messages["You did not supply a From address."] = "Kimden adresi salamadnz.";
$net2ftp_messages["You did not supply a To address."] = "Kime adresi salamdnz.";
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "FTP sunucusundan k yaptnz. Geri giri yapmak iin, <a href=\"%1\$s\" title=\"Giri sayfas (accesskey l)\" accesskey=\"l\">bu balanty takip edin</a>.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "IP adresiniz (%1\$s) yasakl IP adresleri listesinde.";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Your IP address (%1\$s) is not in the list of allowed IP addresses.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "IP adresiniz deiti; ltfen <b>%1\$s</b> devam etmek iin,FTP sunucusu iin ifrenizi girin.";
$net2ftp_messages["Your browser does not support applets, or you have disabled applets in your browser settings."] = "Your browser does not support applets, or you have disabled applets in your browser settings.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "Ana dizininiz <b>%1\$s</b> yok veya seilemiyor.";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Oturumunuz sona erdi; ltfen <b>%1\$s</b> devam etmek iin,FTP sunucusu iin ifrenizi girin.";
$net2ftp_messages["Your task was stopped"] = "leminiz durduruldu";
$net2ftp_messages["Zip"] = "Zip";
$net2ftp_messages["Zip archive"] = "Zip ariv paketi";
$net2ftp_messages["Zip entries"] = "Zip girileri";
$net2ftp_messages["Zip the selected entries to save or email them"] = "Kaydedebilmek veya e-posta ile gnderebilmek iin, seili girileri ziple";
$net2ftp_messages["en"] = "tr";
$net2ftp_messages["files which were last modified"] = "son deitirilen dosyalar";
$net2ftp_messages["files with a filename like"] = "Benzer adl dosyalar";
$net2ftp_messages["files with a size"] = "boyutlu dosyalar";
$net2ftp_messages["from"] = "kimden";
$net2ftp_messages["iso-8859-1"] = "iso-8859-9";
$net2ftp_messages["left"] = "left";
$net2ftp_messages["ltr"] = "ltr";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp, FTP sunucusu ile web sunucusu arasnda dizin haritas belirlemeyi denedi .";    //mapping: ?
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp GNU/GPL lisans altnda piyasaya srlen bedava bir yazlmdr. Daha fazla bilgi iin, http://www.net2ftp.com ye gidin.";
$net2ftp_messages["no - please install it!"] = "hayr - ltfen onu ykle!";
$net2ftp_messages["not OK"] = "TAMAM deil";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "TAMAM deil. %1\$s dizinin iznini denetliyor";
$net2ftp_messages["right"] = "right";
$net2ftp_messages["to"] = "kime";
$net2ftp_messages["to:"] = "e:";
$net2ftp_messages["yes"] = "evet";

?>