<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2018 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a ete copie vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------

$net2ftp_messages["%1\$s File"] = "%1\$s Fil";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(Bemærk: Dette link virker måske ikke hvis du ikke har dit eget internetdomæne.)";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> kunne ikke omdøbes til <b>%2\$s</b>";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> blev omdøbt til <b>%2\$s</b>";
$net2ftp_messages["ARC archive"] = "ARC arkiv";
$net2ftp_messages["ARJ archive"] = "ARJ arkiv";
$net2ftp_messages["ASP script"] = "ASP script";
$net2ftp_messages["Action"] = "Handling";
$net2ftp_messages["Actions"] = "Handlinger";
$net2ftp_messages["Add another"] = "Tilføj flere";
$net2ftp_messages["Adobe Acrobat document"] = "Adobe Acrobat dokument";
$net2ftp_messages["Advanced"] = "Avanceret";
$net2ftp_messages["Advanced FTP functions"] = "Avancerede FTP funktioner";
$net2ftp_messages["Advanced functions"] = "Avancerede funktioner";
$net2ftp_messages["Advanced login"] = "Advanced login";
$net2ftp_messages["All"] = "Alle";
$net2ftp_messages["All the selected directories and files have been processed."] = "Alle de valgte mapper og filer er bearbejdet.";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "Alle undermapper og filer vil også blive slettet!";
$net2ftp_messages["Alternatively, use net2ftp's normal upload or upload-and-unzip functionality."] = "Alternatively, use net2ftp's normal upload or upload-and-unzip functionality.";
$net2ftp_messages["An error has occured"] = "En fejl er opstået";
$net2ftp_messages["Anonymous"] = "Log på som anonym";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "Arkivet <b>%1\$s</b> blev ikke behandlet fordi filtypen ikke blev genkendt. Kun zip, tar, tgz og gz arkiver understøttes i øjeblikket.";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "Arkiv indeholder filnavne med ../ eller ..\\ - afbryder udpakning";
$net2ftp_messages["Archives"] = "Arkiver";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Valgte arkiver bliver automatisk udpakket og filerne overføres til FTP serveren.";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "Er du sikker på du vil slette disse mapper og filer?";
$net2ftp_messages["Ascending order"] = "Stigende orden";
$net2ftp_messages["Automatic"] = "Automatisk";
$net2ftp_messages["Back"] = "Tilbage";
$net2ftp_messages["Basic FTP login"] = "Basic FTP login";
$net2ftp_messages["Basic SSH login"] = "Basic SSH login";
$net2ftp_messages["Bitmap file"] = "Bitmap fil";
$net2ftp_messages["Bookmark"] = "Gem som favorit/bogmærke";
$net2ftp_messages["Calculate the size of the selected entries"] = "Udregn størrelsen på det valgte";
$net2ftp_messages["Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Cascading Style Sheet"] = "Cascading Style Sheet";
$net2ftp_messages["Case sensitive search"] = "Forskel på store og små bogstaver";
$net2ftp_messages["Changing the directory"] = "Ændrer mappevisning";
$net2ftp_messages["Changing to the directory %1\$s: "] = "Skifter til mappen %1\$s: ";
$net2ftp_messages["Character encoding: "] = "Tegnsæt: ";
$net2ftp_messages["Check the SSH server's public key fingerprint"] = "Check the SSH server's public key fingerprint";
$net2ftp_messages["Checking files"] = "Kontrollerer filer";
$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "Kontrollerer om PHP-FTP modulet er installeret: ";
$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "Kontrollerer mappetilladelser på webserveren: en lille fil bliver oprettet i /temp mappen og derefter slettet.";
$net2ftp_messages["Chmod"] = "Rettigheder";
$net2ftp_messages["Chmod also the files within this directory"] = "Ret også filer i denne mappe";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "Ret også undermapper i denne mappe";
$net2ftp_messages["Chmod directories and files"] = "Ret rettigheder (Chmod) for filer og mapper";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "Ret rettigheder (Chmod) for de valgte mapper og filer (virker kun på Unix/Linux/BSD servere)";
$net2ftp_messages["Choose"] = "Vælg";
$net2ftp_messages["Choose a directory"] = "Vælg en mappe";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "Klik for at sortere via %1\$s i stigende orden";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "Klik for at sortere via %1\$s i faldende orden";
$net2ftp_messages["Closing the file: "] = "Lukker filen: ";
$net2ftp_messages["Connecting to a test FTP server: "] = "Forbinder til en test FTP server: ";
$net2ftp_messages["Connecting to the FTP server"] = "Forbinder til FTP serveren";
$net2ftp_messages["Connecting to the FTP server: "] = "Forbinder til FTP serveren: ";
$net2ftp_messages["Connection from net2ftp server to Google captcha server failed"] = "Connection from net2ftp server to Google captcha server failed";
$net2ftp_messages["Connection settings:"] = "Forbindelsesindstillinger:";
$net2ftp_messages["Continue"] = "Fortsæt";
$net2ftp_messages["Copied file %1\$s"] = "Kopierede fil %1\$s";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Kopierede filen <b>%1\$s</b>";
$net2ftp_messages["Copy"] = "Kopiér";
$net2ftp_messages["Copy directories and files"] = "Kopiér mapper og filer";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "Kopiér mappen: <b>%1\$s</b> til:";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "Kopiér fil <b>%1\$s</b> til:";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "Kopiér symlink <b>%1\$s</b> til:";
$net2ftp_messages["Copy the selected entries"] = "Kopiér valgte";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Kopierer net2ftp installer scriptet til FTP serveren";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Could not connect to SSH server"] = "Could not connect to SSH server";
$net2ftp_messages["Could not copy file %1\$s"] = "Kan ikke kopiere filen %1\$s";
$net2ftp_messages["Could not create directory %1\$s"] = "Kan ikke oprette mappen %1\$s";
$net2ftp_messages["Could not generate a temporary file."] = "Kan ikke oprette en midlertidig fil.";
$net2ftp_messages["Could not get fingerprint"] = "Could not get fingerprint";
$net2ftp_messages["Could not get public host key"] = "Could not get public host key";
$net2ftp_messages["Could not unzip entry %1\$s (error code %2\$s)"] = "Could not unzip entry %1\$s (error code %2\$s)";
$net2ftp_messages["Create a new file in directory %1\$s"] = "Lav en ny fil i mappen: %1\$s";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Lav hurtigt en webside via eksisterende skabeloner";
$net2ftp_messages["Create new directories"] = "Opret en ny mappe";
$net2ftp_messages["Create the MySQL database tables"] = "Opret MySQL databasetabellerne";
$net2ftp_messages["Created directory %1\$s"] = "Oprettede mappen %1\$s";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Oprettede undermappen <b>%1\$s</b>";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Opretter midlertidig mappe på FTP serveren";
$net2ftp_messages["Creating filename: "] = "Opretter filnavn: ";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "Daglig grænse nået: filen <b>%1\$s</b> bliver ikke overført";
$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "Daglig datagrænse nået: Du kan ikke overføre mere data i dag";
$net2ftp_messages["Data transferred from this IP address today"] = "Data overført fra denne IP adresse i dag";
$net2ftp_messages["Data transferred to this FTP server today"] = "Data overført til denne FTP server i dag";
$net2ftp_messages["Date from:"] = "Fra dato:";
$net2ftp_messages["Dear,"] = "Kære,";
$net2ftp_messages["Decompressing archives and transferring files"] = "Udpakker arkiver og overfører filer";
$net2ftp_messages["Default"] = "Standard";
$net2ftp_messages["Delete"] = "Slet";
$net2ftp_messages["Delete directories and files"] = "Slet mapper og filer";
$net2ftp_messages["Delete the selected entries"] = "Slet valgte";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "Slettede filen <b>%1\$s</b>";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "Slettede undermappen <b>%1\$s</b>";
$net2ftp_messages["Deleting the file: "] = "Sletter filen: ";
$net2ftp_messages["Descending order"] = "Faldende orden";
$net2ftp_messages["Details"] = "Detalier";
$net2ftp_messages["Different target FTP server:"] = "Anden FTP server:";
$net2ftp_messages["Directories"] = "Mapper";
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "Mapper der indeholder tegnet \' kan ikke vises korrekt. De kan kun slettes. Gå tilbage og vælg en anden mappe.";
$net2ftp_messages["Directory"] = "Mappe";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "Mappe: <b>%1\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "Mappen: <b>%1\$s</b> kunne ikke oprettes.";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "Mappen <b>%1\$s</b> blev chmodded til <b>%2\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "Mappen: <b>%1\$s</b> er oprettet.";
$net2ftp_messages["Directory Tree"] = "Mappeoversigt";
$net2ftp_messages["Disabled"] = "Deaktiveret";
$net2ftp_messages["Double-click to go to a subdirectory:"] = "Dobbeltklik for at gå til en mappe:";
$net2ftp_messages["Download"] = "Download";
$net2ftp_messages["Download a zip file containing all selected entries"] = "Download en zip fil med alle filer og mapper";
$net2ftp_messages["Download the file %1\$s"] = "Download filen: %1\$s";
$net2ftp_messages["Drag and drop one of the links below to the bookmarks bar"] = "Drag and drop one of the links below to the bookmarks bar";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Tekniske problemer forhindrede afsendelsen af e-mailen <b>%1\$s</b>.";
$net2ftp_messages["Edit"] = "Redigér";
$net2ftp_messages["Edit the source code of file %1\$s"] = "Rediger kildekoden for filen: %1\$s";
$net2ftp_messages["Email is too long; please enter less than 255 characters."] = "Email is too long; please enter less than 255 characters.";
$net2ftp_messages["Email the zip file in attachment to:"] = "Mail den komprimerede fil som en vedhæftning til:";
$net2ftp_messages["Empty logs"] = "Tøm logs";
$net2ftp_messages["Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21"] = "Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21";
$net2ftp_messages["Enter your email address"] = "Enter your email address";
$net2ftp_messages["Enter your password"] = "Enter your password";
$net2ftp_messages["Enter your username"] = "Enter your username";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Mapper og filer der indeholder blokkerede nøgleord kan ikke håndteres i net2ftp. Dette er for at undgå misbrug med bl.a. Paypal eller Ebay.";
$net2ftp_messages["Example"] = "Eksempel";
$net2ftp_messages["Executable"] = "Program";
$net2ftp_messages["Execute %1\$s in a new window"] = "Kør %1\$s i et nyt vindue";
$net2ftp_messages["FTP mode"] = "FTP modus";
$net2ftp_messages["FTP server"] = "FTP server";
$net2ftp_messages["FTP server name is too long; please enter less than 255 characters."] = "FTP server name is too long; please enter less than 255 characters.";
$net2ftp_messages["FTP server port"] = "FTP server port";
$net2ftp_messages["FTP server response:"] = "FTP server svar:";
$net2ftp_messages["File"] = "Fil";
$net2ftp_messages["File <b>%1\$s</b>"] = "File <b>%1\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "Filen <b>%1\$s</b> kunne ikke flyttes";
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "Filen <b>%1\$s</b> kunne ikke overføres til FTP serveren";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "Filen <b>%1\$s</b> blev overført til FTP servern via FTP modus <b>%2\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "Filen <b>%1\$s</b> er OK";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "Filen <b>%1\$s</b> indeholder blokerede nøgleord. Denne fil bliver ikke uploadet.";
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "Filen <b>%1\$s</b> er for stor. Denne fil bliver ikke uploadet.";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "Filen <b>%1\$s</b> blev chmodded til <b>%2\$s</b>";
$net2ftp_messages["File: "] = "Fil: ";
$net2ftp_messages["Files"] = "Filer";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Valgte filer bliver overført til FTP serveren.";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Filer som er for store kan ikke downloades, uploades, kopieres, flyttes, gennemsøges, komprimeres, udpakkes, vises eller redigeres. De kan kun omdøbes, slettes eller du kan rette filens chmod-rettigheder.";
$net2ftp_messages["Find files which contain a particular word"] = "Find filer som indeholder et bestemt ord";
$net2ftp_messages["Fingerprint"] = "Fingerprint";
$net2ftp_messages["Follow symlink %1\$s"] = "Følg symlinket: %1\$s";
$net2ftp_messages["Font file"] = "Font fil";
$net2ftp_messages["Forums"] = "Forum";
$net2ftp_messages["GIF file"] = "GIF fil";
$net2ftp_messages["GIMP file"] = "GIMP fil";
$net2ftp_messages["GZ archive"] = "GZ arkiv";
$net2ftp_messages["Get fingerprint"] = "Get fingerprint";
$net2ftp_messages["Get the SSH server's public key fingerprint before logging in to verify the server's identity"] = "Get the SSH server's public key fingerprint before logging in to verify the server's identity";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Henter %1\$s ud af %2\$s arkiver fra FTP serveren";
$net2ftp_messages["Getting fingerprint, please wait..."] = "Getting fingerprint, please wait...";
$net2ftp_messages["Getting the FTP server system type: "] = "Henter FTP server system type: ";
$net2ftp_messages["Getting the FTP system type"] = "Henter FTP system type";
$net2ftp_messages["Getting the current directory"] = "Henter aktuelle mappevisning";
$net2ftp_messages["Getting the list of directories and files"] = "Henter liste over mapper og filer";
$net2ftp_messages["Getting the raw list of directories and files: "] = "Henter rå data om mapper og filer: ";
$net2ftp_messages["Go"] = "Udfør";
$net2ftp_messages["Go back"] = "Tilbage";
$net2ftp_messages["Go to the advanced functions"] = "Gå til de udvidede indstillinger";
$net2ftp_messages["Go to the login page"] = "Gå til login siden";
$net2ftp_messages["Go to the parent directory"] = "Gå til øvre mappe";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "Gå til mappen: %1\$s";
$net2ftp_messages["Group"] = "Gruppe";
$net2ftp_messages["HTML file"] = "HTML fil";
$net2ftp_messages["HTML templates"] = "HTML skabeloner";
$net2ftp_messages["Help"] = "Hjælp";
$net2ftp_messages["Help Guide"] = "Hjælp";
$net2ftp_messages["IP address: "] = "IP addresse: ";
$net2ftp_messages["Icons"] = "Ikoner";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Hvis destinationen findes i forvejen bliver indholdet erstattet";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "Hvis du ikke kender til dette eller hvis du ikke har tillid til afsenderen så slet denne e-mail og lad være med at åbne det vedhæftede arkiv.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "Har du behov for ubegrænset forbrug så kan du installere net2ftp på din egen server.";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "Hvis du har behov for at net2ftp skal udføre handlinger der tager længere tid burde du overveje at installere net2ftp på din egen server.";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "Hvis du vil kopiere filerne til en anden FTP server skal du angive FTP serverens login oplysninger.";
$net2ftp_messages["Image"] = "Billede";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "For at håndhæve et fair forbrug af vores webserver er der sat begrænsninger på hvor meget data hver bruger kan overføre pr. dag. Når grænsen er nået kan du stadig bruge net2ftp, men du kan ikke overføre data til eller fra serveren.";
$net2ftp_messages["In order to run it, click on the link below."] = "For at køre scriptet skal du klikke på linket herunder.";
$net2ftp_messages["Information about the sender: "] = "Information om afsenderen: ";
$net2ftp_messages["Initial directory"] = "Mappe";
$net2ftp_messages["Install"] = "net2ftp Installer";
$net2ftp_messages["Install software packages"] = "Installer software pakker";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Installér software pakker (kræver PHP installeret på denne server)";
$net2ftp_messages["JPEG file"] = "JPEG fil";
$net2ftp_messages["Java Upload"] = "Upload via Java";
$net2ftp_messages["Java source file"] = "Java source fil";
$net2ftp_messages["JavaScript file"] = "JavaScript fil";
$net2ftp_messages["Language:"] = "Sprog:";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Efterlad disse felter blanke hvis du ikke vil kopiere noget til andre FTP servere.";
$net2ftp_messages["License"] = "Licens";
$net2ftp_messages["Line"] = "Linje";
$net2ftp_messages["List"] = "Liste";
$net2ftp_messages["List of commands:"] = "liste over kommandoer:";
$net2ftp_messages["Logging"] = "Logger";
$net2ftp_messages["Logging into the FTP server"] = "Logger på FTP serveren";
$net2ftp_messages["Logging into the FTP server: "] = "Logger på FTP serveren: ";
$net2ftp_messages["Logging out of the FTP server"] = "Logger af FTP serveren";
$net2ftp_messages["Login"] = "Log ind";
$net2ftp_messages["Login!"] = "Log ind!";
$net2ftp_messages["Logout"] = "Log ud";
$net2ftp_messages["MOV movie file"] = "MOV film";
$net2ftp_messages["MPEG movie file"] = "MPEG film";
$net2ftp_messages["MS Office - Access database"] = "MS Office - Access database";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Excel regneark";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - PowerPoint præsentation";
$net2ftp_messages["MS Office - Project file"] = "MS Office - Project fil";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Visio tegning";
$net2ftp_messages["MS Office - Word document"] = "MS Office - Word dokument";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "Lav en undermappe i mappen: %1\$s";
$net2ftp_messages["Message of the sender: "] = "Afsenderens meddelelse: ";
$net2ftp_messages["Mobile"] = "Mobile";
$net2ftp_messages["Mod Time"] = "Sidst ændret";
$net2ftp_messages["Move"] = "Flyt";
$net2ftp_messages["Move directories and files"] = "Flyt mapper og filer";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "Flyt mappen: <b>%1\$s</b> til:";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "Flyt fil <b>%1\$s</b> til:";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "Flyt symlink <b>%1\$s</b> til:";
$net2ftp_messages["Move the selected entries"] = "Flyt valgte";
$net2ftp_messages["Moved directory <b>%1\$s</b>"] = "Moved directory <b>%1\$s</b>";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "Flyttede filen <b>%1\$s</b>";
$net2ftp_messages["MySQL database"] = "MySQL database";
$net2ftp_messages["MySQL password"] = "MySQL adgangskode";
$net2ftp_messages["MySQL password length"] = "Længde af MySQL adgangskode";
$net2ftp_messages["MySQL server"] = "MySQL server";
$net2ftp_messages["MySQL username"] = "MySQL brugernavn";
$net2ftp_messages["Name"] = "Navn";
$net2ftp_messages["New dir"] = "Ny mappe";
$net2ftp_messages["New directory name:"] = "Mappenavn:";
$net2ftp_messages["New file"] = "Ny fil";
$net2ftp_messages["New file name: "] = "Nyt filnavn: ";
$net2ftp_messages["New name: "] = "Nyt navn: ";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Bemærk: Hvis du ikke åbner arkiverne så kan filerne i arkivet ikke skade din computer.";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "Bemærk det ikke er anonymt at sende filer: din IP adresse og afsendelsestidspunktet bliver noteret i mailen.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "Bemærk: andre brugere af denne computer kan klikke på tilbageknappen i browseren og få adgang til FTP serveren.";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Bemærk: placeringen skal være oprettet i forvejen før du kan kopiere noget dertil.";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "Bemærk: Når du benytter dette bogmærke bliver du spurgt om dit brugernavn og adgangskode";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["OK. Filename: %1\$s"] = "OK. Filnavn: %1\$s";
$net2ftp_messages["Old name: "] = "Gammelt navn: ";
$net2ftp_messages["One click access (net2ftp won't ask for a password - less safe)"] = "One click access (net2ftp won't ask for a password - less safe)";
$net2ftp_messages["Open"] = "Åben";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 regneark";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Calc 6.0 skabelon";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Draw 6.0 dokument";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Draw 6.0 skabelon";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 præsentation";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Impress 6.0 skabelon";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Math 6.0 dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Writer 6.0 dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Writer 6.0 globalt dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Writer 6.0 skabelon";
$net2ftp_messages["Opening the file in write mode: "] = "Åbner filen i skrivningsmodus: ";
$net2ftp_messages["Owner"] = "Ejer";
$net2ftp_messages["PHP Source"] = "PHP Source";
$net2ftp_messages["PHP script"] = "PHP script";
$net2ftp_messages["PNG file"] = "PNG fil";
$net2ftp_messages["Parsing the file"] = "Indlæser fil";
$net2ftp_messages["Parsing the list of directories and files"] = "Indlæser liste over mapper og filer";
$net2ftp_messages["Passive mode"] = "Passiv modus";
$net2ftp_messages["Password"] = "Adgangskode";
$net2ftp_messages["Password length"] = "Længde på adgangskode";
$net2ftp_messages["Perms"] = "Rettigheder";
$net2ftp_messages["Please agree to all privacy policies."] = "Please agree to all privacy policies.";
$net2ftp_messages["Please enter a password."] = "Indtast en adganskode.";
$net2ftp_messages["Please enter a username."] = "Indtast et brugernavn.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Indtast en gyldig dato i formatet ÅÅÅÅ-M-D i \"fra\" tekstfeltet.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Indtast en gyldig dato i formatet ÅÅÅÅ-M-D i \"til\" tekstfeltet.";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "Indtast en gyldig filstørrelse i  \"fra\" tekstfeltet, f.eks. 0.";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "Indtast en gyldig filstørrelse i \"til\" tekstfeltet, f.eks. 500000.";
$net2ftp_messages["Please enter a valid filename."] = "Indtast et gyldigt filnavn.";
$net2ftp_messages["Please enter a valid search word or phrase."] = "Indtast et ord eller en sætning.";
$net2ftp_messages["Please enter an FTP server."] = "Indtast en FTP server.";
$net2ftp_messages["Please enter your Administrator username and password."] = "Indtast enten dit brugernavn eller din adgangskode.";
$net2ftp_messages["Please enter your MySQL settings:"] = "Indtast dine MySQL indstillinger:";
$net2ftp_messages["Please enter your email address as identifier to give you the right of access and erasure:"] = "Please enter your email address as identifier to give you the right of access and erasure:";
$net2ftp_messages["Please enter your email address."] = "Please enter your email address.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Indtast dit brugernavn og adgangskode for FTP serveren: <b>%1\$s</b>.";
$net2ftp_messages["Please specify a filename"] = "Indtast et filnavn";
$net2ftp_messages["Please wait..."] = "Vent venligst...";
$net2ftp_messages["Powered by"] = "Styres via";
$net2ftp_messages["Printing the list of directories and files"] = "Viser liste over mapper og filer";
$net2ftp_messages["Printing the result"] = "Udskriver resultatet";
$net2ftp_messages["Privacy notices"] = "Privacy notices";
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "Behandler arkiv nr. %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "Behandler mappen <b>%1\$s</b>";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "Processing entries within directory <b>%1\$s</b>:";
$net2ftp_messages["Processing entry %1\$s"] = "Bearbejder opgave %1\$s";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "Behandling af mappen <b>%1\$s</b> færdig";
$net2ftp_messages["Processing the entries"] = "Bearbejder opgaver";
$net2ftp_messages["Protocol"] = "Protocol";
$net2ftp_messages["Quicktime movie file"] = "Quicktime film";
$net2ftp_messages["RPM"] = "RPM";
$net2ftp_messages["Reading the file"] = "Læser fil";
$net2ftp_messages["Real movie file"] = "Real film";
$net2ftp_messages["Refresh"] = "Opdater";
$net2ftp_messages["Rename"] = "Omdøb";
$net2ftp_messages["Rename directories and files"] = "Omdøb mapper og filer";
$net2ftp_messages["Rename the selected entries"] = "Omdøb valgte";
$net2ftp_messages["Requested files"] = "Requested files";
$net2ftp_messages["Restrict the search to:"] = "Begræns søgningen til";
$net2ftp_messages["Restrictions:"] = "Begrænsninger:";
$net2ftp_messages["Results:"] = "Resultater:";
$net2ftp_messages["Right-click on one of the links below and choose \"Add to Favorites...\""] = "Right-click on one of the links below and choose \"Add to Favorites...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark This Link...\""] = "Right-click on one of the links below and choose \"Bookmark This Link...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark link...\""] = "Right-click on one of the links below and choose \"Bookmark link...\"";
$net2ftp_messages["Right-click on one the links below and choose \"Add Link to Bookmarks...\""] = "Right-click on one the links below and choose \"Add Link to Bookmarks...\"";
$net2ftp_messages["SSH fingerprint"] = "SSH fingerprint";
$net2ftp_messages["SSH server"] = "SSH server";
$net2ftp_messages["Save"] = "Gem";
$net2ftp_messages["Save the zip file on the FTP server as:"] = "Gem den komprimerede fil på FTP serveren som:";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";
$net2ftp_messages["Script finished in %1\$s seconds"] = "Script udført på %1\$s sekunder";
$net2ftp_messages["Script halted"] = "Script afbrudt";
$net2ftp_messages["Search"] = "Søg";
$net2ftp_messages["Search directories and files"] = "Søg i mapper og filer";
$net2ftp_messages["Search for a word or phrase"] = "Søg efter et ord eller en sætning";
$net2ftp_messages["Search results"] = "Søgeresultater";
$net2ftp_messages["Searching the files..."] = "Søger i filer...";
$net2ftp_messages["Select the directory %1\$s"] = "Vælg mappen: %1\$s";
$net2ftp_messages["Select the file %1\$s"] = "Vælg filen: %1\$s";
$net2ftp_messages["Select the symlink %1\$s"] = "Vælg symlinket: %1\$s";
$net2ftp_messages["Send arbitrary FTP commands"] = "Send arbitrær FTP kommando";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "Send arbitrære FTP kommandoer til FTP serveren";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "Sender FTP kommando %1\$s ud af %2\$s";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Sendt via net2ftp programmet installeret på dette website: ";
$net2ftp_messages["Set all permissions"] = "Sæt alt til dette";
$net2ftp_messages["Set all targetdirectories"] = "Ret alles nye placering";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "Set the permissions of directory <b>%1\$s</b> to: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "Sæt rettigheder for filen: <b>%1\$s</b> til: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "Sæt rettigheder for symlinket: <b>%1\$s</b> til: ";
$net2ftp_messages["Setting the passive mode"] = "Sætter passiv modus";
$net2ftp_messages["Setting the passive mode: "] = "Sætter passiv modus: ";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Retter tilladelser for den midlertidige mappe";
$net2ftp_messages["Settings used:"] = "Anvendte indstillinger:";
$net2ftp_messages["Setup MySQL tables"] = "Opsæt MySQL tabeller";
$net2ftp_messages["Shell script"] = "Shell script";
$net2ftp_messages["Shockwave file"] = "Shockwave fil";
$net2ftp_messages["Shockwave flash file"] = "Shockwave flash fil";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Hvis dette link ikke er korrekt skal du manuelt indtaste URL adressen i din web browser.";
$net2ftp_messages["Size"] = "Størrelse";
$net2ftp_messages["Size of selected directories and files"] = "Størrelse på valgte filer og mapper";
$net2ftp_messages["Skin:"] = "Tema:";
$net2ftp_messages["Some additional comments to add in the email:"] = "Tilføj yderligere kommentarer til mailen:";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Nogen har bedt om at de vedhæftede filer i denne mail skulle sendes til denne e-mail adresse (%1\$s).";
$net2ftp_messages["Standard"] = "Standard";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x regneark";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - StarChart 5.x dokument";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - StarDraw 5.x dokument";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x præsentation";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress pakket 5.x fil";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x mail fil";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - StarMath 5.x dokument";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - StarWriter 5.x dokument";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - StarWriter 5.x globalt dokument";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "Status: <b>Denne fil kunne ikke gemmes</b>";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "Status: Gemt d. <b>%1\$s</b> via %2\$s";
$net2ftp_messages["Status: This file has not yet been saved"] = "Status: Denne fil er ikke blevet gemt endnu";
$net2ftp_messages["Submit"] = "Udfør";
$net2ftp_messages["Symlink"] = "Symlink";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "Symlink <b>%1\$s</b>";
$net2ftp_messages["Symlinks"] = "Symlinks";
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>"] = "Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>";
$net2ftp_messages["TAR archive"] = "TAR arkiv";
$net2ftp_messages["TIF file"] = "TIF fil";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "Tabellen net2ftp_log_access indeholder dubletter.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "Tabellen net2ftp_log_access kunne ikke opdateres.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "Tabellen net2ftp_log_consumption_ftpserver indeholder dubletter.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "Tabellen net2ftp_log_consumption_ftpserver indeholder dubletter.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "Tabellen net2ftp_log_consumption_ftpserver kunne ikke opdateres.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "Tabellen net2ftp_log_consumption_ipaddress indeholder dubletter.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "Tabellen net2ftp_log_consumption_ipaddress indeholder dubletter.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "Tabellen net2ftp_log_consumption_ipaddress kunne ikke opdateres.";
$net2ftp_messages["Table net2ftp_log_status contains duplicate entries."] = "Table net2ftp_log_status contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_status could not be updated."] = "Table net2ftp_log_status could not be updated.";
$net2ftp_messages["Target directory:"] = "Placering:";
$net2ftp_messages["Target name:"] = "Navn:";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "Test net2ftp udskriftsregler";
$net2ftp_messages["Testing the FTP functions"] = "Tester FTP funktionerne";
$net2ftp_messages["Text file"] = "Tekstfil";
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />"] = "The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />";
$net2ftp_messages["The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />"] = "The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "FTP serveren <b>%1\$s</b> er på listen over blokerede FTP servere.";
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "FTP serveren <b>%1\$s</b> er ikke på listen over tilladte FTP servere.";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "FTP serverporten: %1\$s kan ikke benyttes.";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP overførselsmodus (ASCII eller BINARY) vil automatisk blive besluttet ud fra filernes endelser";
$net2ftp_messages["The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />"] = "The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "Indtastningen: <b>%1\$s</b> Er ugyldig. (fra 000 til 777). Prøv igen.";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "Mappen <b>%1\$s</b> indeholder et blokeret nøgleord. Afbryder flytning";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "Mappen <b>%1\$s</b> indeholder et blokeret nøgleord. Denne mappe springes over";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "Mappen <b>%1\$s</b> kunne ikke hentes - du har måske ikke tilstrækkelige rettigheder for at se denne mappe, eller også findes mappen ikke.";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "Mappen <b>%1\$s</b> kunne ikke vælges. Denne mappe springes over";
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "Mappen <b>%1\$s</b> findes enten ikke, eller kunne ikke hentes, mappen <b>%2\$s</b> vises i stedet for.";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "Den valgte mailadresse (%1\$s) bestod ikke valideringen.<br />Indtast en mail i formatet <b>eksempel@domæne.dk</b>";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "Filen <b>%1\$s</b> indeholder et blokeret nøgleord. Afbryder flytning";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "Filen <b>%1\$s</b> indeholder et blokeret nøgleord. Denne fil springes over";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "Filen <b>%1\$s</b> er for stor til at blive kopieret. Denne fil springes over";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "Filen <b>%1\$s</b> er for stor til at blive flyttet. Afbryder flytning";
$net2ftp_messages["The file is too big to be transferred"] = "Filen er for stor til at blive sendt";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "Information om den nyeste version kunne ikke hentes fra net2ftps server. Kontrollér sikkerhedsindstillingerne for din browser da disse kan forhindre indlæsningen fra net2ftp.com serveren.";
$net2ftp_messages["The log tables could not be copied."] = "The log tables could not be copied.";
$net2ftp_messages["The log tables could not be renamed."] = "The log tables could not be renamed.";
$net2ftp_messages["The log tables were copied successfully."] = "The log tables were copied successfully.";
$net2ftp_messages["The log tables were renamed successfully."] = "The log tables were renamed successfully.";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Upload af filer må højst vare <b>%1\$s sekunder</b>";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>"] = "The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>";
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "Net2ftp installer scriptet er kopieret til FTP serveren.";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "Den nye mappe bliver oprettet i: <b>%1\$s</b>.";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "Det nye navn må ikke indeholde blokerede nøgleord. Denne mappe eller fil kunne ikke omdøbes til <b>%1\$s</b>";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "Det nye navn må ikke indeholde punktummer. Denne mappe eller fil kunne ikke omdøbes til <b>%1\$s</b>";
$net2ftp_messages["The number of files which were skipped is:"] = "Antal filer der ikke blev regnet med:";
$net2ftp_messages["The oldest log table could not be dropped."] = "The oldest log table could not be dropped.";
$net2ftp_messages["The oldest log table was dropped successfully."] = "The oldest log table was dropped successfully.";
$net2ftp_messages["The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment)."] = "The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment).";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "Tabellen <b>%1\$s</b> kunne ikke tømmes.";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "Tabellen <b>%1\$s</b> kunne ikke optimeres.";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "Tabellen <b>%1\$s</b> er tømt.";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "Tabellen <b>%1\$s</b> er optimeret.";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "Destinationen <b>%1\$s</b> er den samme mappe eller en undermappe til den oprindelige mappe <b>%2\$s</b>, denne mappe springes over";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "Destinationen for filen <b>%1\$s</b> er den samme som den oprindelige mappe. Denne fil springes over";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "Handlingen du var i gang med at udføre på net2ftp tog længere tid end de tilladte %1\$s sekunder og blev derfor stoppet.";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "Den samlede størrelse på de valgte filer og mapper er:";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "Variablen  <b>consumption_ipaddress_datatransfer</b> er ikke nummerisk.";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "Ordet <b>%1\$s</b> blev fundet i følgende mapper og filer:";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "Ordet <b>%1\$s</b> blev ikke fundet iblandt de valgte mapper og filer.";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "Arkivet er gemt på FTP serveren med navnet <b>%1\$s</b>";
$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "Arkivet er blevet sendt til <b>%1\$s</b>.";
$net2ftp_messages["This SQL query is going to be executed:"] = "Denne SQL forespørgsel bliver kørt:";
$net2ftp_messages["This file is not accessible from the web"] = "Denne fil kan ikke bruges på nettet";
$net2ftp_messages["This folder is empty"] = "Denne mappe er tom";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "Denne funktion er blevet deaktiveret af websidens administrator.";
$net2ftp_messages["This function is available on PHP 5 only"] = "Denne funktion er kun tilgængelig i PHP 5 eller nyere";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "Dette script kører via din web server og kræver at PHP er installeret.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "Denne tidsbegrænsning sikrer at fair forbrug af serverens ressourcer for alle brugere.";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "Denne version af net2ftp er opdateret.";
$net2ftp_messages["Time of sending: "] = "Afsendelsestidspunkt: ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "For at undgå dette, så luk alle browservinduer.";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "For at gemme billedet, højreklik og vælg 'Gem billede som...'";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "For at rette alles nye placering så indtast placeringen i feltet herover og klik på \"Ret alles nye placering\".";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\"";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\"";
$net2ftp_messages["To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now."] = "To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now.";
$net2ftp_messages["Transferring files to the FTP server"] = "Overfører filer til FTP serveren";
$net2ftp_messages["Transform selected entries: "] = "Bearbejdt valgte: ";
$net2ftp_messages["Troubleshoot an FTP server"] = "Fejsøg en FTP server";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "Fejlsøg net2ftp på denne server";
$net2ftp_messages["Troubleshoot your net2ftp installation"] = "Test din net2ftp installation";
$net2ftp_messages["Troubleshooting functions"] = "Fejlsøgningsfunktioner";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Prøv at dele din handling op i mindre handlinger: begræns dit udvalg af filer og undgå de største filer.";
$net2ftp_messages["Two click access (net2ftp will ask for a password - safer)"] = "Two click access (net2ftp will ask for a password - safer)";
$net2ftp_messages["Type"] = "Type";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Kan ikke lukke den midlertidige fils handle";
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Kan ikke få forbindelse til FTP serveren <b>%1\$s</b> via port <b>%2\$s</b>.<br /><br />Kontroller at dette er den rigtige adresse til FTP serveren. Denne er ofte forskellig fra HTTP (web) serveren. Kontakt din udbyders helpdesk eller administrator for yderligere hjælp.<br />";
$net2ftp_messages["Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Kan ikke få forbindelse til MySQL databasen. Kontrollér dine MySQL indstillinger i net2ftp's konfigurationsfil settings.inc.php.";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "Kan ikke kopiere filen <b>%1\$s</b>";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "Kan ikke kopiere den lokale fil til den fjerne fil <b>%1\$s</b> via FTP modus <b>%2\$s</b>";
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "Kan ikke kopiere den fjerne fil <b>%1\$s</b> til den lokale fil via FTP modus <b>%2\$s</b>";
$net2ftp_messages["Unable to create a temporary directory (too many tries)"] = "Unable to create a temporary directory (too many tries)";
$net2ftp_messages["Unable to create a temporary directory because (parent directory is not writeable)"] = "Unable to create a temporary directory because (parent directory is not writeable)";
$net2ftp_messages["Unable to create a temporary directory because (unvalid parent directory)"] = "Unable to create a temporary directory because (unvalid parent directory)";
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "Kan ikke oprette mappen <b>%1\$s</b>";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "Kan ikke oprette undermappen <b>%1\$s</b>. Den findes måske allerede. Fortsætter kopiering/flytning...";
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "Kan ikke oprette den midlertidige fil. Kontrollér rettighederne for mappen %1\$s.";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "Unable to delete file <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "Kan ikke slette mappen <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "Kan ikke slette filen <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the local file"] = "Kan ikke slette den lokale fil";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "Kan ikke slette undermappen <b>%1\$s</b> - den er måske ikke tom";
$net2ftp_messages["Unable to delete the temporary directory"] = "Kan ikke slette den midlertidige mappe";
$net2ftp_messages["Unable to delete the temporary file"] = "Kan ikke slette den midlertidige fil";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Kan ikke slette den midlertidige fil %1\$s";
$net2ftp_messages["Unable to determine your IP address."] = "Kan ikke afgøre din IP adresses ophav.";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "Kan ikke udføre site command <b>%1\$s</b>";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "Kan ikke udføre site command <b>%1\$s</b>. Bemærk at CHMOD kommandoen kun er tilgængelig på Unix FTP servere, ikke på Windows FTP servere.";
$net2ftp_messages["Unable to execute the SQL query."] = "Kan ikke udføre SQL forespørgsel.";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Kan ikke udpakke filer og mapper fra arkivet";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Kan ikke hente arkivet: <b>%1\$s</b> fra FTP serveren";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "Kan ikke hente filen <b>%1\$s</b> fra FTP serveren og gemme den som den midlertidig fil <b>%2\$s</b>.<br />Kontrollér rettighederne for mappen %3\$s.<br />";
$net2ftp_messages["Unable to get the list of packages"] = "Ude af stand til at hente listen over pakker";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Kan ikke logge på FTP serveren <b>%1\$s</b> med brugernavnet <b>%2\$s</b>.<br /><br />Kontroller om brugernavn og adgangskode er korrekt indtastet. Kontakt din udbyders helpdesk eller administrator for yderligere hjælp.<br />";
$net2ftp_messages["Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to move the directory <b>%1\$s</b>"] = "Unable to move the directory <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>"] = "Unable to move the file <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Kan ikke flytte filen <b>%1\$s</b>. Afbryder flytning";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "Kan ikke flytte den uploadede fil til den midlertidige mappe.<br /><br />Administratoren af denne webside skal sætte rettighederne for /temp mappen i net2ftp til<b>chmod 777</b>.";
$net2ftp_messages["Unable to open the system log."] = "Kan ikke åbne system loggen.";
$net2ftp_messages["Unable to open the template file"] = "Kan ikke åbne skabelon filen";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Kan ikke åbne den midlertidige fil. Kontrollér rettighederne for mappen %1\$s.";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "Kan ikke sende filen <b>%1\$s</b> til FTP serveren.<br />Du har muligvis ikke skriverettigheder for denne mappe.";
$net2ftp_messages["Unable to read the template file"] = "Kan ikke læse skabelon filen";
$net2ftp_messages["Unable to read the temporary file"] = "Kan ikke læse den midlertidige fil";
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "Kan ikke omdøbe mappen eller filen <b>%1\$s</b> til <b>%2\$s</b>";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Kan ikke vælge MySQL databasen. Kontrollér dine MySQL indstillinger i net2ftp's konfigurationsfil settings.inc.php.";
$net2ftp_messages["Unable to send the file to the browser"] = "Kan ikke sende filen til browseren";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "Kan ikke skifte til passiv modus på FTP serveren <b>%1\$s</b>.";
$net2ftp_messages["Unable to write a message to the system log."] = "Kan ikke skrive i system loggen.";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "Kan ikke skrive strengen til den midlertidige fil <b>%1\$s</b>.<br />Kontrollér rettighederne for mappen %2\$s.";
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "Uventet strengtilstand: %1\$s. Afbryder.";
$net2ftp_messages["Unrecognized FTP output"] = "Ukendt FTP output";
$net2ftp_messages["Unzip"] = "Udpak";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Udpakker arkiv: <b>%1\$s</b> til:";
$net2ftp_messages["Unzip archives"] = "Udpak arkiver";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Udpak det valgte arkiv på FTP serveren";
$net2ftp_messages["Up"] = "Op";
$net2ftp_messages["Update"] = "Opdatér";
$net2ftp_messages["Upload"] = "Upload";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "Upload en ny version af filen: %1\$s og sammenflet ændringerne med den nuværende fil";
$net2ftp_messages["Upload directories and files using a Java applet"] = "Upload mapper og filer via et Java applet";
$net2ftp_messages["Upload files and archives"] = "Upload filer og mapper";
$net2ftp_messages["Upload more files and archives"] = "Upload flere filer og mapper";
$net2ftp_messages["Upload new files in directory %1\$s"] = "Upload nye filer til mappen: %1\$s";
$net2ftp_messages["Upload to directory:"] = "Upload til mappe:";
$net2ftp_messages["Username"] = "Brugernavn";
$net2ftp_messages["Username is too long; please enter less than 255 characters."] = "Username is too long; please enter less than 255 characters.";
$net2ftp_messages["Version information"] = "Version information";
$net2ftp_messages["View"] = "Vis kildekode";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Se Macromedia ShockWave Flash film %1\$s";
$net2ftp_messages["View file %1\$s"] = "Se fil %1\$s";
$net2ftp_messages["View image %1\$s"] = "Se billedet: %1\$s";
$net2ftp_messages["View logs"] = "Se logs";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "Se filen: %1\$s fra din HTTP web server";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Se den fremhævede kildekode for filen: %1\$s";
$net2ftp_messages["WAV sound file"] = "WAV lydfil";
$net2ftp_messages["Webmaster's email: "] = "Webmasterens e-mail: ";
$net2ftp_messages["Writing some text to the file: "] = "Skriver noget tekst i filen: ";
$net2ftp_messages["Wrong username or password. Please try again."] = "Forkert brugernavn eller adgangskode. Prøv igen.";
$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "Du angav ikke et filnavn for den komprimerede fil. Gå tilbage og angiv et filnavn.";
$net2ftp_messages["You did not enter your Administrator username or password."] = "Du fik ikke indtastet dit brugernavn eller din adgangskode.";
$net2ftp_messages["You did not provide any file to upload."] = "Du skal vælge de filer der skal uploades.";
$net2ftp_messages["You did not provide any text to send by email!"] = "Du har ikke angivet noget tekst der skal sendes via e-mail!";
$net2ftp_messages["You did not supply a From address."] = "Du har ikke angivet en Fra adresse.";
$net2ftp_messages["You did not supply a To address."] = "Du har ikke angivet en Til adresse.";
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "Du er logget ud af din FTP server. <a href=\"%1\$s\" title=\"Login side (ALT + l)\" accesskey=\"l\">Log på igen</a>.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "Din IP adresse (%1\$s) er på listen over blokerede IP adresser.";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Din IP adresse (%1\$s) er ikke på listen over tilladte IP adresser.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Din IP adresse er ændret; log ind igen for at fortsætte dit arbejde på FTP serveren: <b>%1\$s</b>.";
$net2ftp_messages["Your browser does not support applets, or you have disabled applets in your browser settings."] = "Your browser does not support applets, or you have disabled applets in your browser settings.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "Rodmappen <b>%1\$s</b> findes enten ikke eller kunne ikke hentes.";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Dit login er udløbet. Log ind igen for at fortsætte dit arbejde på FTP serveren: <b>%1\$s</b>.";
$net2ftp_messages["Your task was stopped"] = "Handlingen blev afbrudt";
$net2ftp_messages["Zip"] = "Komprimér";
$net2ftp_messages["Zip archive"] = "Zip arkiv";
$net2ftp_messages["Zip entries"] = "Komprimerede filer";
$net2ftp_messages["Zip the selected entries to save or email them"] = "Komprimer de valgte filer og mapper og enten gem eller email dem";
$net2ftp_messages["en"] = "da";
$net2ftp_messages["files which were last modified"] = "filer der senest blev ændret";
$net2ftp_messages["files with a filename like"] = "filer med et filnavn som";
$net2ftp_messages["files with a size"] = "filer med en størrelse";
$net2ftp_messages["from"] = "fra";
$net2ftp_messages["iso-8859-1"] = "UTF-8";
$net2ftp_messages["left"] = "left";
$net2ftp_messages["ltr"] = "ltr";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "Net2ftp prøvede at afgøre mappestrukturen mellem FTP serveren og web serveren.";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp er gratis software der er udgivet under GNU/GPL licensen. For yderligere information, gå til http://www.net2ftp.com.";
$net2ftp_messages["no - please install it!"] = "nej - installer dette modul!";
$net2ftp_messages["not OK"] = "ej OK";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "ej OK. Kontroller tilladelserne for mappen %1\$s";
$net2ftp_messages["right"] = "right";
$net2ftp_messages["to"] = "til";
$net2ftp_messages["to:"] = "til:";
$net2ftp_messages["yes"] = "Ja";

?>