<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2018 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a ete copie vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------

$net2ftp_messages["%1\$s File"] = "Tệp %1\$s";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(Chý ý: đường dẫn này có thể không làm việc nếu như bạn không có một tên miền.)";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> không thể đổi tên thành <b>%2\$s</b>";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> đã đổi tên thành công thành <b>%2\$s</b>";
$net2ftp_messages["ARC archive"] = "Lưu trữ dạng ARC";
$net2ftp_messages["ARJ archive"] = "Lưu trữ dạng ARJ";
$net2ftp_messages["ASP script"] = "Ngôn ngữ ASP";
$net2ftp_messages["Action"] = "Hành động";
$net2ftp_messages["Actions"] = "Các hành động";
$net2ftp_messages["Add another"] = "Thêm vào cái khác";
$net2ftp_messages["Adobe Acrobat document"] = "Tài liệu Adobe Acrobat";
$net2ftp_messages["Advanced"] = "Nâng cao";
$net2ftp_messages["Advanced FTP functions"] = "Những chức năng FTP nâng cao";
$net2ftp_messages["Advanced functions"] = "Chức năng quản trị";
$net2ftp_messages["Advanced login"] = "Advanced login";
$net2ftp_messages["All"] = "Tất cả";
$net2ftp_messages["All the selected directories and files have been processed."] = "Tất cả các thư mục và tệp đã lựa chọn dang trong quá trình thực hiện.";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "Tất cả thư mục và tệp con của thư mục đã lựa chọn cũng sẽ bị xóa!";
$net2ftp_messages["Alternatively, use net2ftp's normal upload or upload-and-unzip functionality."] = "Alternatively, use net2ftp's normal upload or upload-and-unzip functionality.";
$net2ftp_messages["An error has occured"] = "Có lỗi xảy ra";
$net2ftp_messages["Anonymous"] = "Vô danh";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "Lưu trữ <b>%1\$s</b> không thể giải nén bởi vì loại tệp này không được chấp nhận. Chỉ có những lưu trữ dạng zip, tar, tgz và gz được hỗ trợ tại thời điểm này.";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "Archive contains filenames with ../ or ..\\ - aborting the extraction";
$net2ftp_messages["Archives"] = "Các lưu tr&#7919";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Những lưu trữ này sẽ được giải nén, và các tệp trong đó sẽ đươc chuyển tới máy chủ FTP.";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "Bạn có chắc chắn muốn xoá các thư mục và các tệp này?";
$net2ftp_messages["Ascending order"] = "Tăng lên theo thứ tự";
$net2ftp_messages["Automatic"] = "Tự động";
$net2ftp_messages["Back"] = "Quay lại";
$net2ftp_messages["Basic FTP login"] = "Basic FTP login";
$net2ftp_messages["Basic SSH login"] = "Basic SSH login";
$net2ftp_messages["Bitmap file"] = "Tệp Bitmap";
$net2ftp_messages["Bookmark"] = "Mục ưa thích";
$net2ftp_messages["Calculate the size of the selected entries"] = "Tính toán kích thước của các kết quả đã lựa chọn";
$net2ftp_messages["Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Cascading Style Sheet"] = "Cascading Style Sheet";
$net2ftp_messages["Case sensitive search"] = "Case sensitive search";
$net2ftp_messages["Changing the directory"] = "Đang chuyển thư mục";
$net2ftp_messages["Changing to the directory %1\$s: "] = "Đang chuyển tới thư mục %1\$s: ";
$net2ftp_messages["Character encoding: "] = "Character encoding: ";
$net2ftp_messages["Check the SSH server's public key fingerprint"] = "Check the SSH server's public key fingerprint";
$net2ftp_messages["Checking files"] = "Đang kiểm tra các tệp";
$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "Đánh dấu nếu module FTP của PHP đã được cài đặt: ";
$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "Kiểm tra sự cho phép của thư mục trên máy chủ: một tệp nhỏ sẽ được ghi thử để kiểm tra rồi sau đó sẽ bị xóa.";
$net2ftp_messages["Chmod"] = "Thay đổi kiểu";
$net2ftp_messages["Chmod also the files within this directory"] = "Chmod tất cả các tệp thuộc thư mục này";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "Chmod tất cả các thư mục con của thư mục này";
$net2ftp_messages["Chmod directories and files"] = "Chmod thư mục và tệp";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "Chmod các kết quả đã lựa chọn (chỉ làm viêc trên máy chủ Unix/Linux )";
$net2ftp_messages["Choose"] = "Lựa chọn";
$net2ftp_messages["Choose a directory"] = "Chọn một thư mục";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "Hãy nhấp chuột để sắp xếp %1\$s theo sự tăng dần của thứ tự";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "Hãy nhấp chuột để sắp xếp %1\$s theo sự giảm dần của thứ tự";
$net2ftp_messages["Closing the file: "] = "Đang đóng tệp: ";
$net2ftp_messages["Connecting to a test FTP server: "] = "Connecting to a test FTP server: ";
$net2ftp_messages["Connecting to the FTP server"] = "Đang kết nối tới máy chủ FTP";
$net2ftp_messages["Connecting to the FTP server: "] = "Đang kết nối với máy chủ FTP: ";
$net2ftp_messages["Connection from net2ftp server to Google captcha server failed"] = "Connection from net2ftp server to Google captcha server failed";
$net2ftp_messages["Connection settings:"] = "Nhữg cấu hình kết nối:";
$net2ftp_messages["Continue"] = "Tiếp tục";
$net2ftp_messages["Copied file %1\$s"] = "Copied file %1\$s";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Đã sao chép tệp <b>%1\$s</b>";
$net2ftp_messages["Copy"] = "Sao chép";
$net2ftp_messages["Copy directories and files"] = "Sao chép các thư mục và các tệp";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "Sao chép thư mục <b>%1\$s</b> tới:";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "Sao chép tệp <b>%1\$s</b> tới:";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "Sao chép lối tắt <b>%1\$s</b> tới:";
$net2ftp_messages["Copy the selected entries"] = "Sao chép kết quả đã lựa chọn";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Copying the net2ftp installer script to the FTP server";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Could not connect to SSH server"] = "Could not connect to SSH server";
$net2ftp_messages["Could not copy file %1\$s"] = "Could not copy file %1\$s";
$net2ftp_messages["Could not create directory %1\$s"] = "Could not create directory %1\$s";
$net2ftp_messages["Could not generate a temporary file."] = "Không thể tạo ra một tệp tạm thời.";
$net2ftp_messages["Could not get fingerprint"] = "Could not get fingerprint";
$net2ftp_messages["Could not get public host key"] = "Could not get public host key";
$net2ftp_messages["Could not unzip entry %1\$s (error code %2\$s)"] = "Could not unzip entry %1\$s (error code %2\$s)";
$net2ftp_messages["Create a new file in directory %1\$s"] = "Tạo một tệp mới trong thư mục %1\$s";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Tạo một trang web mới dễ dàng với các giao diện HTML đã có sẵn";
$net2ftp_messages["Create new directories"] = "Tạo thư mục mới";
$net2ftp_messages["Create the MySQL database tables"] = "Tạo các bảng MySQL";
$net2ftp_messages["Created directory %1\$s"] = "Created directory %1\$s";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Đã tạo thư mục con đến <b>%1\$s</b>";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Creating a temporary directory on the FTP server";
$net2ftp_messages["Creating filename: "] = "Đang tạo tệp có tên: ";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "Tới hạn hàng ngày: tệp <b>%1\$s</b> sẽ không được chuyển";
$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "Tới hạn: bạn sẽ không thể không truyền tải được dữ liệu";
$net2ftp_messages["Data transferred from this IP address today"] = "Data transferred from this IP address today";
$net2ftp_messages["Data transferred to this FTP server today"] = "Data transferred to this FTP server today";
$net2ftp_messages["Date from:"] = "Từ ngày:";
$net2ftp_messages["Dear,"] = "Xin chào,";
$net2ftp_messages["Decompressing archives and transferring files"] = "Đang nén và chuyển các tệp";
$net2ftp_messages["Default"] = "Mặc định";
$net2ftp_messages["Delete"] = "Xóa";
$net2ftp_messages["Delete directories and files"] = "Xóa các thư mục và các tệp";
$net2ftp_messages["Delete the selected entries"] = "Xóa kết quả đã lựa chọn";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "Đã xóa tệp <b>%1\$s</b>";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "Đã xóa thư mục con <b>%1\$s</b>";
$net2ftp_messages["Deleting the file: "] = "Đang xóa tệp: ";
$net2ftp_messages["Descending order"] = "Giảm dần theo thứ tự";
$net2ftp_messages["Details"] = "Chi tiết";
$net2ftp_messages["Different target FTP server:"] = "Đến một máy chủ FTP khác:";
$net2ftp_messages["Directories"] = "Các thư mục";
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "Những thư mục với tên chứa đựng \' có thể không hiển thị đúng. Chúng có thể bị xóa. Xin vui lòng quay lại và lựa chon thư mục con khác.";
$net2ftp_messages["Directory"] = "Thư mục";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "Thư mục <b>%1\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "Thư mục <b>%1\$s</b> đã không thể tạo.";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "Thư mục <b>%1\$s</b> đã thay đổi kiểu thành công thành <b>%2\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "Thư mục <b>%1\$s</b> đã đươc tạo thành công.";
$net2ftp_messages["Directory Tree"] = "Cây thư mục";
$net2ftp_messages["Disabled"] = "Ngừng hiệu lực";
$net2ftp_messages["Double-click to go to a subdirectory:"] = "Nháy chuột để tới một thư mục con:";
$net2ftp_messages["Download"] = "Tải phần mềm";
$net2ftp_messages["Download a zip file containing all selected entries"] = "Tải xuống một tệp nén chứa tất cả các kết quả đã lựa chọn";
$net2ftp_messages["Download the file %1\$s"] = "Tải tệp %1\$s";
$net2ftp_messages["Drag and drop one of the links below to the bookmarks bar"] = "Drag and drop one of the links below to the bookmarks bar";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Có lỗi xảy ra khi gửi email tới <b>%1\$s</b> đã không thể gửi.";
$net2ftp_messages["Edit"] = "Sửa đổi";
$net2ftp_messages["Edit the source code of file %1\$s"] = "Sửa đổi mã nguồn của tệp %1\$s";
$net2ftp_messages["Email is too long; please enter less than 255 characters."] = "Email is too long; please enter less than 255 characters.";
$net2ftp_messages["Email the zip file in attachment to:"] = "Gửi tệp nén này tới:";
$net2ftp_messages["Empty logs"] = "Làm rỗng nhật ký";
$net2ftp_messages["Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21"] = "Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21";
$net2ftp_messages["Enter your email address"] = "Enter your email address";
$net2ftp_messages["Enter your password"] = "Enter your password";
$net2ftp_messages["Enter your username"] = "Enter your username";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp.";
$net2ftp_messages["Example"] = "Ví dụ";
$net2ftp_messages["Executable"] = "Executable";
$net2ftp_messages["Execute %1\$s in a new window"] = "Thực hiện %1\$s trong một của sổ mới";
$net2ftp_messages["FTP mode"] = "Kiểu FTP";
$net2ftp_messages["FTP server"] = "Máy chủ FTP";
$net2ftp_messages["FTP server name is too long; please enter less than 255 characters."] = "FTP server name is too long; please enter less than 255 characters.";
$net2ftp_messages["FTP server port"] = "Cổng";
$net2ftp_messages["FTP server response:"] = "Máy chủ FTP trả lời:";
$net2ftp_messages["File"] = "Tệp";
$net2ftp_messages["File <b>%1\$s</b>"] = "Tệp <b>%1\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "Tệp <b>%1\$s</b> có thể không được di chuyển";
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "Tệp <b>%1\$s</b> có thể không được chuyển  tới máy chủ FTP";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "Tệp <b>%1\$s</b> đã được chuyển  tới máy chủ FTP, sử dụng kiểu FTP <b>%2\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "Đã <b>%1\$s</b> đã xong";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded.";
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "Tệp <b>%1\$s</b> quá lớn, nó sẽ không thể đưa lên được.";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "Tệp <b>%1\$s</b> đã thay đổi kiểu thành công thành <b>%2\$s</b>";
$net2ftp_messages["File: "] = "Tệp: ";
$net2ftp_messages["Files"] = "Các tệp";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Những tệp vừa nhập vào sẽ đươc chuyển tới máy chủ FTP.";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted.";
$net2ftp_messages["Find files which contain a particular word"] = "Tìm kiếm các tệp có chứa đựng khóa";
$net2ftp_messages["Fingerprint"] = "Fingerprint";
$net2ftp_messages["Follow symlink %1\$s"] = "Follow symlink %1\$s";
$net2ftp_messages["Font file"] = "Tệp Font";
$net2ftp_messages["Forums"] = "Diễn đàn";
$net2ftp_messages["GIF file"] = "Tệp GIF";
$net2ftp_messages["GIMP file"] = "Tệp GIMP";
$net2ftp_messages["GZ archive"] = "Lưu trữ dạng GZ";
$net2ftp_messages["Get fingerprint"] = "Get fingerprint";
$net2ftp_messages["Get the SSH server's public key fingerprint before logging in to verify the server's identity"] = "Get the SSH server's public key fingerprint before logging in to verify the server's identity";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Getting archive %1\$s of %2\$s from the FTP server";
$net2ftp_messages["Getting fingerprint, please wait..."] = "Getting fingerprint, please wait...";
$net2ftp_messages["Getting the FTP server system type: "] = "Đang lập kiểu hệ thống của máy chủ FTP: ";
$net2ftp_messages["Getting the FTP system type"] = "Đang lập kiểu hệ thống của máy chủ FTP";
$net2ftp_messages["Getting the current directory"] = "Đang lập thư mục hiện tại";
$net2ftp_messages["Getting the list of directories and files"] = "Đang sắp xếp các tệp và các thư mục";
$net2ftp_messages["Getting the raw list of directories and files: "] = "Đang lập danh sách của các tệp và các thư mục: ";
$net2ftp_messages["Go"] = "Đi";
$net2ftp_messages["Go back"] = "Quay lại";
$net2ftp_messages["Go to the advanced functions"] = "Đi tới những chức năng nâng cao";
$net2ftp_messages["Go to the login page"] = "Tới trang đăng nhập";
$net2ftp_messages["Go to the parent directory"] = "Tới thư mục chủ";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "Đi tới thư mục %1\$s";
$net2ftp_messages["Group"] = "Nhóm";
$net2ftp_messages["HTML file"] = "Tệp HTML";
$net2ftp_messages["HTML templates"] = "Giao diện HTML";
$net2ftp_messages["Help"] = "Trợ giúp";
$net2ftp_messages["Help Guide"] = "Hướng dẫn";
$net2ftp_messages["IP address: "] = "Địa chỉ IP: ";
$net2ftp_messages["Icons"] = "Biểu tượng";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Nếu đã tồn tại một tệp tương tự trên máy chủ FTP, nó sẽ bị ghi đè lên";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "Nếu bạn không biết cái này hoặc bạn không tin cậy vào nhân vật đã gửi nó vui lòng xóa bức thư này.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "Nếu bạn cần sử dụng nhiều lần và thường xuyên, hãy cài đặt nó lên máy chủ của bạn.";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "Nếu bạn cần sử dụng trong một thời gian dài, hãy cài đặt nó trên máy chủ của bạn.";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "Nếu bạn muốn sao chép các tệp tới một máy chủ FTP khác, hãy nhập vào dữ liệu đăng nhập.";
$net2ftp_messages["Image"] = "Ảnh";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "Trong nội quy, để bảo đảm sự công bằng tới tất cả mọi người, băng thông truyền tải và thời gian sử dụng sẽ giới hạn đối với 1 người dùng, và một ngày. Một khi tới giới hạn, bạn vẫn còn trình duyệt FTP, nhưng không thể sử dụng nó.";
$net2ftp_messages["In order to run it, click on the link below."] = "In order to run it, click on the link below.";
$net2ftp_messages["Information about the sender: "] = "Thông tin về người gửi: ";
$net2ftp_messages["Initial directory"] = "Thư mục tới";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Install software packages"] = "Install software packages";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Install software packages (requires PHP on web server)";
$net2ftp_messages["JPEG file"] = "Tệp JPEG";
$net2ftp_messages["Java Upload"] = "Đưa lên bằng Java";
$net2ftp_messages["Java source file"] = "Tệp mã nguồn Java";
$net2ftp_messages["JavaScript file"] = "Tệp mã nguồn JavaScript";
$net2ftp_messages["Language:"] = "Ngôn ng&#7919:";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Để trống nếubạn muốn sao chép các tệp tới cùng một tài khoản trên máy chủ FTP.";
$net2ftp_messages["License"] = "Đăng ký";
$net2ftp_messages["Line"] = "Đường thẳng";
$net2ftp_messages["List"] = "Danh sách";
$net2ftp_messages["List of commands:"] = "Danh sách các lệnh:";
$net2ftp_messages["Logging"] = "Đang đăng nhập";
$net2ftp_messages["Logging into the FTP server"] = "Đang đăng nhập vào với máy chủ FTP";
$net2ftp_messages["Logging into the FTP server: "] = "Đang đăng nhập vào máy chủ FTP: ";
$net2ftp_messages["Logging out of the FTP server"] = "Đang đăng xuất khỏi máy chủ FTP";
$net2ftp_messages["Login"] = "Đăng nhập";
$net2ftp_messages["Login!"] = "Đăng nhập!";
$net2ftp_messages["Logout"] = "Đăng xuất";
$net2ftp_messages["MOV movie file"] = "Tệp MOV movie";
$net2ftp_messages["MPEG movie file"] = "Tệp MPEG movie";
$net2ftp_messages["MS Office - Access database"] = "Cơ sở dữ liệu MS Office - Access";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Excel spreadsheet";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - PowerPoint presentation";
$net2ftp_messages["MS Office - Project file"] = "Tệp MS Office - Project";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Visio drawing";
$net2ftp_messages["MS Office - Word document"] = "Tài liệu MS Office - Word";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "Tạo một thư mục con trong thư mục %1\$s";
$net2ftp_messages["Message of the sender: "] = "Tin nhắn của người gửi: ";
$net2ftp_messages["Mobile"] = "Mobile";
$net2ftp_messages["Mod Time"] = "Kiểu thời gian";
$net2ftp_messages["Move"] = "Di chuyển";
$net2ftp_messages["Move directories and files"] = "Di chuyển các thư mục và các tệp";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "Di chuyển thư mục <b>%1\$s</b> tới:";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "Di chuyển tệp <b>%1\$s</b> tới:";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "Di chuyển lối tắt <b>%1\$s</b> tới:";
$net2ftp_messages["Move the selected entries"] = "Di chuyển kết quả đã lựa chọn";
$net2ftp_messages["Moved directory <b>%1\$s</b>"] = "Moved directory <b>%1\$s</b>";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "Đã di chuyển tệp <b>%1\$s</b>";
$net2ftp_messages["MySQL database"] = "Tên cơ sở dữ liệu";
$net2ftp_messages["MySQL password"] = "Mật khẩu";
$net2ftp_messages["MySQL password length"] = "Độ dài của mật khẩu MySQL";
$net2ftp_messages["MySQL server"] = "Máy chủ MySQL";
$net2ftp_messages["MySQL username"] = "Tên dùng";
$net2ftp_messages["Name"] = "Tên";
$net2ftp_messages["New dir"] = "Thư mục mới";
$net2ftp_messages["New directory name:"] = "Tên thư mục mới:";
$net2ftp_messages["New file"] = "Tệp mới";
$net2ftp_messages["New file name: "] = "Tên tệp mới: ";
$net2ftp_messages["New name: "] = "Tên mới: ";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Hãy chú ý là nếu bạn không giải nén tệp lưu trữ thì những tệp trong đó sẽ không làm hại máy tính của bạn.";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "Hãy chú ý là email không nặc danh: địa chỉ IP của bạn cũng như thời gian gửi sẽ được thêm vào email.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "Chú ý: một người dùng khác sử dụng chiếc máy tính này có thể ấn vào nút Back trên trình duyệt và có thể trở lại máy chủ FTP.";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Chú ý: đích đến phải tồn tại trước khi bất kỳ thứ gì có thể được sao chép tới nó.";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "Chú ý: khi bạn sử dụng chức năng này, một cửa sổ mới sẽ hiện lên và yêu cầu bạn nhập tên sử dụng và mật khẩu.";
$net2ftp_messages["OK"] = "Thành công";
$net2ftp_messages["OK. Filename: %1\$s"] = "Thành công. Tên tệp là: %1\$s";
$net2ftp_messages["Old name: "] = "Tên cũ: ";
$net2ftp_messages["One click access (net2ftp won't ask for a password - less safe)"] = "One click access (net2ftp won't ask for a password - less safe)";
$net2ftp_messages["Open"] = "Mở";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 spreadsheet";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "Giao diện OpenOffice - Calc 6.0";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "Tài liệu OpenOffice - Draw 6.0";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "Giao diện OpenOffice - Draw 6.0";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 presentation";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "Giao diện OpenOffice - Impress 6.0";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "Tài liệu OpenOffice - Math 6.0";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "Tài liệu OpenOffice - Writer 6.0";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "Tài liệu OpenOffice - Writer 6.0 global";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = " Giao diệnOpenOffice - Writer 6.0";
$net2ftp_messages["Opening the file in write mode: "] = "Đang mở tệp trong chế đọ ghi: ";
$net2ftp_messages["Owner"] = "Người tạo nên";
$net2ftp_messages["PHP Source"] = "Mã nguồn PHP";
$net2ftp_messages["PHP script"] = "Ngôn ngữ PHP";
$net2ftp_messages["PNG file"] = "Tệp PNG";
$net2ftp_messages["Parsing the file"] = "Đang phân tích  tệp";
$net2ftp_messages["Parsing the list of directories and files"] = "Đang phân tích danh sách của các thư mục và các tệp";
$net2ftp_messages["Passive mode"] = "Kiểu thụ động";
$net2ftp_messages["Password"] = "Mật khẩu";
$net2ftp_messages["Password length"] = "Độ dài của mật khẩu";
$net2ftp_messages["Perms"] = "Vị trí";
$net2ftp_messages["Please agree to all privacy policies."] = "Please agree to all privacy policies.";
$net2ftp_messages["Please enter a password."] = "Xin vui lo`nng nhap mat khau.";
$net2ftp_messages["Please enter a username."] = "Xin vui lo`nng nhap ten dung.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Xin vui lòng điền đúng định dạng năm-tháng-ngày vào ô trống \"từ\".";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Xin vui lòng điền đúng định dạng năm-tháng-ngày vào ô trống \"đến\".";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "Xin vui lòng điền đúng kích thước tệp vào  ô trống \"từ\" , ví dụ: 0.";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "Xin vui lòng điền đúng kích thước tệp vào ô trống \"đến\", ví dụ: 500000.";
$net2ftp_messages["Please enter a valid filename."] = "Xin vui lòng điền đúng tên tệp.";
$net2ftp_messages["Please enter a valid search word or phrase."] = "Xin vui lòng điền đúng từ khoá hay câu tìm kiếm.";
$net2ftp_messages["Please enter an FTP server."] = "Xin vui lo`nng nhap mot may chu FTP.";
$net2ftp_messages["Please enter your Administrator username and password."] = "Xin vui lòng nhập tên dùng và mật khẩu của người quản trị";
$net2ftp_messages["Please enter your MySQL settings:"] = "Xin vui lòng nhập cấu hình của MySQL:";
$net2ftp_messages["Please enter your email address as identifier to give you the right of access and erasure:"] = "Please enter your email address as identifier to give you the right of access and erasure:";
$net2ftp_messages["Please enter your email address."] = "Please enter your email address.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Please enter your username and password for FTP server <b>%1\$s</b>.";
$net2ftp_messages["Please specify a filename"] = "Xin vui lòng xác định một tên tệp";
$net2ftp_messages["Please wait..."] = "Xin vui lòng chờ...";
$net2ftp_messages["Powered by"] = "Mã nguồn được cung cấp bởi";
$net2ftp_messages["Printing the list of directories and files"] = "Đang in danh sách các tệp và các thư mục";
$net2ftp_messages["Printing the result"] = "Đang in kết quả";
$net2ftp_messages["Privacy notices"] = "Privacy notices";
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "Đang mở lưu trữ nr %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "Đang thực hiện quá trình với thư mục <b>%1\$s</b>";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "Đang trong quá trình với thư mục <b>%1\$s</b>:";
$net2ftp_messages["Processing entry %1\$s"] = "Processing entry %1\$s";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "Quá trình của thư mục <b>%1\$s</b> đã hoàn thành";
$net2ftp_messages["Processing the entries"] = "Đang trong quá trình";
$net2ftp_messages["Protocol"] = "Protocol";
$net2ftp_messages["Quicktime movie file"] = "Tệp Quicktime movie";
$net2ftp_messages["RPM"] = "RPM";
$net2ftp_messages["Reading the file"] = "Đang đọc tệp";
$net2ftp_messages["Real movie file"] = "Tệp Real movie";
$net2ftp_messages["Refresh"] = "Làm tươi";
$net2ftp_messages["Rename"] = "Đổi tên";
$net2ftp_messages["Rename directories and files"] = "Đổi tên các thư mục và các tệp";
$net2ftp_messages["Rename the selected entries"] = "Đổi tên kết quả đã lựa chọn";
$net2ftp_messages["Requested files"] = "Những tệp đã yêu cầu";
$net2ftp_messages["Restrict the search to:"] = "Tìm kiếm lại một các kỹ lưỡng tới:";
$net2ftp_messages["Restrictions:"] = "Những giới hạn:";
$net2ftp_messages["Results:"] = "Kết quả:";
$net2ftp_messages["Right-click on one of the links below and choose \"Add to Favorites...\""] = "Right-click on one of the links below and choose \"Add to Favorites...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark This Link...\""] = "Right-click on one of the links below and choose \"Bookmark This Link...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark link...\""] = "Right-click on one of the links below and choose \"Bookmark link...\"";
$net2ftp_messages["Right-click on one the links below and choose \"Add Link to Bookmarks...\""] = "Right-click on one the links below and choose \"Add Link to Bookmarks...\"";
$net2ftp_messages["SSH fingerprint"] = "SSH fingerprint";
$net2ftp_messages["SSH server"] = "SSH server";
$net2ftp_messages["Save"] = "Lưu";
$net2ftp_messages["Save the zip file on the FTP server as:"] = "Lưu tệp nén trên máy chủ FTP tại:";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";
$net2ftp_messages["Script finished in %1\$s seconds"] = "Công việc hoàn thành trong %1\$s giây";
$net2ftp_messages["Script halted"] = "Công viêc đã tạm dừng";
$net2ftp_messages["Search"] = "Tìm kiếm";
$net2ftp_messages["Search directories and files"] = "Tìm kiếm các thư mục và tệp";
$net2ftp_messages["Search for a word or phrase"] = "Tìm kiếm một từ hoặc một câu";
$net2ftp_messages["Search results"] = "Kết quả tìm kiếm";
$net2ftp_messages["Searching the files..."] = "Đang tìm kiếm các tệp...";
$net2ftp_messages["Select the directory %1\$s"] = "Lựa chọn thư mục %1\$s";
$net2ftp_messages["Select the file %1\$s"] = "Lựa chọn tệp %1\$s";
$net2ftp_messages["Select the symlink %1\$s"] = "Lựa chọn lối tắt %1\$s";
$net2ftp_messages["Send arbitrary FTP commands"] = "Tự động gửi các lệnh FTP";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "Tự động gửi lệnh FTP tới máy chủ FTP";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "Đang gửi câu lệnh FTP %1\$s của %2\$s";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Được gửi bằng đường được cài đặt trên máy chủ: ";
$net2ftp_messages["Set all permissions"] = "Lập tất cả sự cho phép";
$net2ftp_messages["Set all targetdirectories"] = "Lập tất cả các thư mục tới";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "Đã thay đổi sự cho phép của thư mục <b>%1\$s</b> thành: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "Đã thay đổi sự cho phép của tệp <b>%1\$s</b> thành: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "Đã thay đổi sự cho phép của lố tắt <b>%1\$s</b> thành: ";
$net2ftp_messages["Setting the passive mode"] = "Cấu hình kiểu thụ động";
$net2ftp_messages["Setting the passive mode: "] = "Cấu hình kiểu thụ động:";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Setting the permissions of the temporary directory";
$net2ftp_messages["Settings used:"] = "Cấu hình sử dụng:";
$net2ftp_messages["Setup MySQL tables"] = "Cài đặt các bảng MySQL";
$net2ftp_messages["Shell script"] = "Ngôn ngữ Shell";
$net2ftp_messages["Shockwave file"] = "Tệp Shockwave";
$net2ftp_messages["Shockwave flash file"] = "Tệp Shockwave Flash";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Should this link not be correct, enter the URL manually in your web browser.";
$net2ftp_messages["Size"] = "Kích thước";
$net2ftp_messages["Size of selected directories and files"] = "Kích thước của các thư mục và tệp đã lựa chọn";
$net2ftp_messages["Skin:"] = "Giao diện:";
$net2ftp_messages["Some additional comments to add in the email:"] = "Thêm tin nhắn vào email:";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Một ai đó đã gửi cho bạn những tệp dạng nén (%1\$s).";
$net2ftp_messages["Standard"] = "Standard";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x spreadsheet";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "Tài liệu StarOffice - StarChart 5.x";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "Tài liệu StarOffice - StarDraw 5.x";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x presentation";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress Packed 5.x file";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x mail file";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "Tài liệu StarOffice - StarMath 5.x";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "Tài liệu StarOffice - StarWriter 5.x";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "Tài liệu StarOffice - StarWriter 5.x global";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "Thông báo: <b>Tệp này đã không thể lưu lại được</b>";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "Thông báo: đã lưu <b>%1\$s</b> sử dụng kiểu %2\$s";
$net2ftp_messages["Status: This file has not yet been saved"] = "Thông báo: tệp không được lưu lại";
$net2ftp_messages["Submit"] = "Thực hiện";
$net2ftp_messages["Symlink"] = "Đường dẫn tượng trưng";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "Lối tắt <b>%1\$s</b>";
$net2ftp_messages["Symlinks"] = "Các lối tắt";
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>"] = "Syntax highlighting cung cấp bởi <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>";
$net2ftp_messages["TAR archive"] = "Lưu trữ dạng TAR";
$net2ftp_messages["TIF file"] = "Tệp TIF";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "Table net2ftp_log_access contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "Table net2ftp_log_access could not be updated.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "Bảng net2ftp_log_consumption_ftpserver chứa đụng các mục giống nhau.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "Bảng net2ftp_log_consumption_ftpserver chứa đụng các hàng giống nhau.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "Bảng net2ftp_log_consumption_ftpserver có thể không được cập nhật.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "Bảng net2ftp_log_consumption_ipaddress chứa đụng các mục giống nhau.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "Bảng net2ftp_log_consumption_ipaddress chứa đụng các hàng giống nhau.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "Bảng net2ftp_log_consumption_ipaddress có thể không được cập nhật.";
$net2ftp_messages["Table net2ftp_log_status contains duplicate entries."] = "Table net2ftp_log_status contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_status could not be updated."] = "Table net2ftp_log_status could not be updated.";
$net2ftp_messages["Target directory:"] = "Thư mục đến:";
$net2ftp_messages["Target name:"] = "Tên đến:";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "Kiểm tra danh sách quy luật phân tích của net2ftp";
$net2ftp_messages["Testing the FTP functions"] = "Testing the FTP functions";
$net2ftp_messages["Text file"] = "Tệp văn bản";
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />"] = "The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />";
$net2ftp_messages["The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />"] = "The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "Máy chủ FTP <b>%1\$s</b> nằm trong danh sách các máy chủ bị cấm của.";
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "Máy chủ FTP <b>%1\$s</b> không có ở trong danh sách được chấp nhận của.";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "Cổng máy chủ FTP %1\$s có thể không sử dụng được.";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "Kiểu truyển tải của FTP (ASCII hay BINARY) sẽ được xác định một cách tự động";
$net2ftp_messages["The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />"] = "The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "Lệnh Chmod nr <b>%1\$s</b> đã ra khỏi phạm vi 000-777. Xin vui lòng làm lại.";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The directory <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist.";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "The directory <b>%1\$s</b> could not be selected, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "Thư mục <b>%1\$s</b> không tồn tại hoặc không được lựa chọn, vì vậy thư mục <b>%2\$s</b> được hiển thị để thay vào.";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "Địa chỉ email mà bạn vừa nhập vào (%1\$s) không đúng.<br />Xin vui lòng nhập lại theo định dạng: têndùng@tênmiền.ect</b>";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The file <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "The file <b>%1\$s</b> is too big to be copied, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "The file <b>%1\$s</b> is too big to be moved, aborting the move";
$net2ftp_messages["The file is too big to be transferred"] = "The file is too big to be transferred";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "Phiên bản mới nhất đã không thể được cập nhật từ máy chủ net2ftp.com. Hãy kiểm tra cấu hình bảo mật của trình duyệt của bạn, cái mà có thể cản trở việc cập nhật phiên bản mới nhất từ máy chủ net2ftp.com.";
$net2ftp_messages["The log tables could not be copied."] = "The log tables could not be copied.";
$net2ftp_messages["The log tables could not be renamed."] = "The log tables could not be renamed.";
$net2ftp_messages["The log tables were copied successfully."] = "The log tables were copied successfully.";
$net2ftp_messages["The log tables were renamed successfully."] = "The log tables were renamed successfully.";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Thời gian thực hiên lớn nhất là <b>%1\$s giây</b>";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>"] = "Kích thước lớn nhất của một tệp giới hạn bởi net2ftp tới <b>%1\$s</b> và bởi PHP từ <b>%2\$s</b>";
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "The net2ftp installer script has been copied to the FTP server.";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "Thư mục mới sẽ được tạo trong <b>%1\$s</b>.";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "Tên mới có thể chứa dấu chấm. Không thể đổi tên thành <b>%1\$s</b>";
$net2ftp_messages["The number of files which were skipped is:"] = "Số tệp bị bỏ qua là:";
$net2ftp_messages["The oldest log table could not be dropped."] = "The oldest log table could not be dropped.";
$net2ftp_messages["The oldest log table was dropped successfully."] = "The oldest log table was dropped successfully.";
$net2ftp_messages["The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment)."] = "The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment).";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "Bảng <b>%1\$s</b> đã không thể làm rỗng.";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "Bảng <b>%1\$s</b> đã không thể tối ưu hóa.";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "Bảng <b>%1\$s</b> đã làm rỗng thành công.";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "Bảng <b>%1\$s</b> đã tối ưu hóa thành công.";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "Thư mục đến <b>%1\$s</b> giống như hoặc là một thư mục con của thư mục nguồn <b>%2\$s</b>. Vì vậy, thư mục này sẽ bị bỏ qua";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "Đích tới của tệp <b>%1\$s</b> giống như tệp nguồn. Vì vậy, tệp này sẽ bị bỏ qua";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "Công việc mà bạn muốn thực hiện với net2ftp tiêu tốn nhiều thời gian hơn thời gian cho phép là %1\$s giây, bởi vậy công việc bị dừng lại.";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "Kích thước tổng cộng của các thư mục và tệp đã lựa chọn là:";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "Vật hay thay đổi <b>consumption_ipaddress_datatransfer</b> is not numeric.";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "Từ khoá <b>%1\$s</b> đã được tìm thấy trong các tệp:";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "Từ khoá <b>%1\$s</b> không tìm thấy trong các tệp hay thư mục đã lựa chọn.";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "Tệp zip đã được lưu trên máy chủ FTP tại <b>%1\$s</b>";
$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "Tệp nén đã được gửi tới <b>%1\$s</b>.";
$net2ftp_messages["This SQL query is going to be executed:"] = "Lệnh SQL sẽ được thực hiện:";
$net2ftp_messages["This file is not accessible from the web"] = "Tệp này không có sẵn từ web";
$net2ftp_messages["This folder is empty"] = "Thư mục này trống rỗng";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "This function has been disabled by the Administrator of this website.";
$net2ftp_messages["This function is available on PHP 5 only"] = "Chức năng này chỉ có hiệu lực với PHP 5";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "This script runs on your web server and requires PHP to be installed.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "Thời gian tối đa bảo đảm tuyệt đối cho việc sử dụng máy chủ web tới tất cả mọi ngưới.";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "Phiên bản này của đã được cập nhật.";
$net2ftp_messages["Time of sending: "] = "Thời gian gửi: ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "Để  chắc chắn bạn phải đóng trình duyệt.";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "Để lưu ảnh, nhấp chuột phải lên nó và chọn 'Save picture as...'";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "Để lập một thư mục tới thông thường, hãy nhập thư mục tới vào bên giới và nhấp vào nút\"Lập tất cả các thư mục tới\".";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\"";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "Để lập tất cả sự cho phép nhanh chóng, chọn tất cả sự cho phép ở trên và ấn nút \"Lập tất cả sự cho phép\"";
$net2ftp_messages["To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now."] = "To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now.";
$net2ftp_messages["Transferring files to the FTP server"] = "Đang chuyển các tệp tới máy chủ FTP";
$net2ftp_messages["Transform selected entries: "] = "Thay đổi các kết quả đã lựa chọn: ";
$net2ftp_messages["Troubleshoot an FTP server"] = "Chỉnh đốn lại một máy chủ FTP";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "Chỉnh đốn net2ftp trên máy chủ web này";
$net2ftp_messages["Troubleshoot your net2ftp installation"] = "Chỉnh đốn lại sự cài đặt net2ftp của bạn";
$net2ftp_messages["Troubleshooting functions"] = "Những chức năng chỉnh đón";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Hãy thử chia công việc của bạn thành nhiều công viêc nhỏ hơn: giới hạn những lựa chọn của các tệp, và bỏ đi những tệp lớn.";
$net2ftp_messages["Two click access (net2ftp will ask for a password - safer)"] = "Two click access (net2ftp will ask for a password - safer)";
$net2ftp_messages["Type"] = "Kiểu";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Không thể đóng điều khiển của tệp tạm thời";
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Không thể kết nối tới máy chủ FTP <b>%1\$s</b> với cổng <b>%2\$s</b>.<br /><br />Bạn có chắc chắn đây là địa chỉ của máy chủ FTP ?. Hãy liên hệ với nhà cung cấp dịch vụ của bạn hoặc quản trị của hệ thống để được giúp đỡ.<br />";
$net2ftp_messages["Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "Không thể sao chép tệp <b>%1\$s</b>";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "Không thể sao chép tệp nội vùng tới tệp xa <b>%1\$s</b>, sử dụng kiểu FTP <b>%2\$s</b>";
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "Không thể sao chép tệp xa <b>%1\$s</b> tới tệp nội vùng, sử dụng kiểu FTP <b>%2\$s</b>";
$net2ftp_messages["Unable to create a temporary directory (too many tries)"] = "Unable to create a temporary directory (too many tries)";
$net2ftp_messages["Unable to create a temporary directory because (parent directory is not writeable)"] = "Unable to create a temporary directory because (parent directory is not writeable)";
$net2ftp_messages["Unable to create a temporary directory because (unvalid parent directory)"] = "Unable to create a temporary directory because (unvalid parent directory)";
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "Không thể tạo thư mục <b>%1\$s</b>";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "Không thể tạo thư mục con <b>%1\$s</b>. Nó có thể đã tồn tại. Tiếp tục với quá trình sao chép hoặc di chuyển...";
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "Không thể tạo tệp tạm thời. Hãy kiểm tra sự cho phép của thư mục %1\$s.";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "Không thể xóa tệp <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "Không thể xoá thư mục <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "Không thể xoá tệp <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the local file"] = "Không thể xóa tệp nội vùng";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "Không thể xóa thư mục con <b>%1\$s</b> - nó có thể đã bị làm rỗng";
$net2ftp_messages["Unable to delete the temporary directory"] = "Unable to delete the temporary directory";
$net2ftp_messages["Unable to delete the temporary file"] = "Không thể xóa tệp tạm thời";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Unable to delete the temporary file %1\$s";
$net2ftp_messages["Unable to determine your IP address."] = "Không thể xác định rõ địa chỉ IP của bạn.";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "Không thể thực hiện câu lệnh của site <b>%1\$s</b>";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "Không thể thực hiện câu lệnh <b>%1\$s</b>. Hãy chú ý là lệnh CHMOD chỉ sử dụng được trên máy chủ FTP Unix, không sử dụng được trên máy chủ FTP Windows.";
$net2ftp_messages["Unable to execute the SQL query."] = "Không thể thực hiện SQL query.";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Unable to extract the files and directories from the archive";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Unable to get the archive <b>%1\$s</b> from the FTP server";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "Không thể tải tệp  <b>%1\$s</b> từ máy chủ FTP và lưu nó lại như tệp tạm thời <b>%2\$s</b>.<br />Hãy kiểm tra sự cho phép của thư mục %3\$s.<br />";
$net2ftp_messages["Unable to get the list of packages"] = "Unable to get the list of packages";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Không thể đăng nhập vào máy chủ FTP <b>%1\$s</b> với tên dùng <b>%2\$s</b>.<br /><br />Bạn có chắc chắn là mình nhập đúng thông tin. Hãy liên hệ với nhà cung cấp dịch vụ của bạn hoặc quản trị của hệ thống để được giúp đỡ.<br />";
$net2ftp_messages["Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to move the directory <b>%1\$s</b>"] = "Unable to move the directory <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>"] = "Unable to move the file <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Unable to move the file <b>%1\$s</b>, aborting the move";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "Không thể di chuyển tệp đã đưa lên tới thư mục tạm thời.<br /><br />Quản trị của trang web này đã <b>chmod 777</b> thư mục <b>/temp</b> trên.";
$net2ftp_messages["Unable to open the system log."] = "Unable to open the system log.";
$net2ftp_messages["Unable to open the template file"] = "Không thể mở tệp giao diện";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Không thể mở tệp tạm thời. Hãy kiểm tra sự cho phép của thư mục %1\$s.";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "Không thể đặt tệp <b>%1\$s</b> lên máy chủ FTP.<br />Bạn có thể không được phép ghi lên thư mục này.";
$net2ftp_messages["Unable to read the template file"] = "Không thể đọc tệp giao diện";
$net2ftp_messages["Unable to read the temporary file"] = "Không thể đọc tệp tạm thời";
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "Không thể đổi thư mục hay tên tệp <b>%1\$s</b> thành <b>%2\$s</b>";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";
$net2ftp_messages["Unable to send the file to the browser"] = "Không thể gửi tệp tới trình duyệt";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "Không thể chuyển đổi kiểu thụ động trên máy chủ FTP <b>%1\$s</b>.";
$net2ftp_messages["Unable to write a message to the system log."] = "Unable to write a message to the system log.";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "Không thể ghi lên tệp tạm thời <b>%1\$s</b>.<br />Hãy kiểm tra sự cho phép của thư mục %2\$s.";
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "Unexpected state string: %1\$s. Exiting.";
$net2ftp_messages["Unrecognized FTP output"] = "Không thể thấy rõ đường ra FTP";
$net2ftp_messages["Unzip"] = "Unzip";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Unzip archive <b>%1\$s</b> to:";
$net2ftp_messages["Unzip archives"] = "Unzip archives";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Unzip the selected archives on the FTP server";
$net2ftp_messages["Up"] = "Lên trên";
$net2ftp_messages["Update"] = "Cập nhật";
$net2ftp_messages["Upload"] = "Đưa lên";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "Đưa lên một phiên bản mới của tệp %1\$s và hòa vào những thay đổi";
$net2ftp_messages["Upload directories and files using a Java applet"] = "Đưa lên các thư mục và các tệp sử dụng Java applet";
$net2ftp_messages["Upload files and archives"] = "Đưa lên các tệp và các lưu trữ";
$net2ftp_messages["Upload more files and archives"] = "Đưa lên thêm các tệp và lưu trữ";
$net2ftp_messages["Upload new files in directory %1\$s"] = "Đưa lên những tệp mới vào thư mục %1\$s";
$net2ftp_messages["Upload to directory:"] = "Đưa lên tới thư mục:";
$net2ftp_messages["Username"] = "Tên đùng";
$net2ftp_messages["Username is too long; please enter less than 255 characters."] = "Username is too long; please enter less than 255 characters.";
$net2ftp_messages["Version information"] = "Thông tin phiên bản";
$net2ftp_messages["View"] = "Xem";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Xem tệp Macromedia ShockWave Flash movie %1\$s";
$net2ftp_messages["View file %1\$s"] = "Xem tệp %1\$s";
$net2ftp_messages["View image %1\$s"] = "Xem ảnh %1\$s";
$net2ftp_messages["View logs"] = "Xem nhật ký";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "Xem tệp %1\$s từ máy chủ web của bạn";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Xem mã nguồn của tệp %1\$s";
$net2ftp_messages["WAV sound file"] = "Tệp âm thanh WAV";
$net2ftp_messages["Webmaster's email: "] = "Địa chỉ email của trưởng web: ";
$net2ftp_messages["Writing some text to the file: "] = "Đang ghi một vài từ lên tệp: ";
$net2ftp_messages["Wrong username or password. Please try again."] = "Sai ten dung hoac mat khau. Xin vui long kiem tra va thuc hien lai.";
$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "Bạn đã không nhập tên vào cho tệp nén. Hãy trở lại và điền vào một cái tên.";
$net2ftp_messages["You did not enter your Administrator username or password."] = "Ban chua nhap ten dung hoac mat khau.";
$net2ftp_messages["You did not provide any file to upload."] = "Bạn không cung cấp bất kỳ tệp gì để đưa lên.";
$net2ftp_messages["You did not provide any text to send by email!"] = "Bạn đã không cung cấp bất kỳ văn bản nào để gửi bằng email!";
$net2ftp_messages["You did not supply a From address."] = "Bạn đã không cung cấp địa chỉ đi.";
$net2ftp_messages["You did not supply a To address."] = "Bạn đã không cung cấp địa chỉ tới.";
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "Địa chỉ IP của bạn (%1\$s) đã nằm trong danh sách bị cấm của.";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Your IP address (%1\$s) is not in the list of allowed IP addresses.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your browser does not support applets, or you have disabled applets in your browser settings."] = "Your browser does not support applets, or you have disabled applets in your browser settings.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "Thư mục chủ của bạn <b>%1\$s</b>  không tồn tại hoặc không được lựa chọn.";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your task was stopped"] = "Công việc của bạn đã dừng lại";
$net2ftp_messages["Zip"] = "Nén";
$net2ftp_messages["Zip archive"] = "Lưu trữ dạng Zip";
$net2ftp_messages["Zip entries"] = "Kết quả Zip";
$net2ftp_messages["Zip the selected entries to save or email them"] = "Nén kết quả đã lựa chọn rồi sau đó lưu lại hoặc gửi qua email";
$net2ftp_messages["en"] = "vi";
$net2ftp_messages["files which were last modified"] = "Những tệp được sửa đổi sau cùng";
$net2ftp_messages["files with a filename like"] = "những tệp có tên giống nhau";
$net2ftp_messages["files with a size"] = "những tệp có cùng kích thước";
$net2ftp_messages["from"] = "từ";
$net2ftp_messages["iso-8859-1"] = "UTF-8";
$net2ftp_messages["left"] = "left";
$net2ftp_messages["ltr"] = "ltr";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp has tried to determine the directory mapping between the FTP server and the web server.";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "Bức thư này được gửi tự động từ http://www.net2ftp.com.";
$net2ftp_messages["no - please install it!"] = "Không - Xin vui lòng cài đặt nó!";
$net2ftp_messages["not OK"] = "Không thành công";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "không thành công. Hãy kiểm tra sự cho phép của thư mục %1\$s";
$net2ftp_messages["right"] = "right";
$net2ftp_messages["to"] = "đến";
$net2ftp_messages["to:"] = "tới:";
$net2ftp_messages["yes"] = "có";

?>