<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2018 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a ete copie vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------

$net2ftp_messages["%1\$s File"] = "%1\$s Fil";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(Notering: Denna lnk kanske inte fungerar om du inte har eget domnnamn.)";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> kunde inte dpas om till <b>%2\$s</b>";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> dptes framgngsrikt om till <b>%2\$s</b>";
$net2ftp_messages["ARC archive"] = "ARC arkiv";
$net2ftp_messages["ARJ archive"] = "ARJ arkiv";
$net2ftp_messages["ASP script"] = "ASP script";
$net2ftp_messages["Action"] = "Funktion";
$net2ftp_messages["Actions"] = "Funktion";
$net2ftp_messages["Add another"] = "Lgg till nsta";
$net2ftp_messages["Adobe Acrobat document"] = "Adobe Acrobat dokument";
$net2ftp_messages["Advanced"] = "Avancerat";
$net2ftp_messages["Advanced FTP functions"] = "Avancerade FTP funktioner";
$net2ftp_messages["Advanced functions"] = "Avancerade funktioner";
$net2ftp_messages["Advanced login"] = "Advanced login";
$net2ftp_messages["All"] = "Alla";
$net2ftp_messages["All the selected directories and files have been processed."] = "Alla valda bibliotek och filer har bearbetats.";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "Alla underbibliotek och filer i de valda biblioteken kommer ocks raderas!";
$net2ftp_messages["Alternatively, use net2ftp's normal upload or upload-and-unzip functionality."] = "Alternatively, use net2ftp's normal upload or upload-and-unzip functionality.";
$net2ftp_messages["An error has occured"] = "Ett fel har uppsttt";
$net2ftp_messages["Anonymous"] = "Anonym";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "Arkiv <b>%1\$s</b> ej bearbetat, filnamnsfrlngning inte igenknt. Bara zip, tar, tgz och gz arkiv stdjs fr tillfllet.";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "Archive contains filenames with ../ or ..\\ - aborting the extraction";
$net2ftp_messages["Archives"] = "Arkive";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Arkive inmatade hr kommer dekomprimeras och filer inuti verfras till FTP servern.";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "r du sker du vill radera dessa bibliotek och filer?";
$net2ftp_messages["Ascending order"] = "Stigande ordning";
$net2ftp_messages["Automatic"] = "Automatiskt";
$net2ftp_messages["Back"] = "Bakt";
$net2ftp_messages["Basic FTP login"] = "Basic FTP login";
$net2ftp_messages["Basic SSH login"] = "Basic SSH login";
$net2ftp_messages["Bitmap file"] = "Bitmap fil";
$net2ftp_messages["Bookmark"] = "Bokmrke";
$net2ftp_messages["Calculate the size of the selected entries"] = "Berkna storlek p valda inmatningar";
$net2ftp_messages["Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Cascading Style Sheet"] = "Cascading Style Sheet";
$net2ftp_messages["Case sensitive search"] = "Case sensitive skning";
$net2ftp_messages["Changing the directory"] = "ndrar i biblioteket";
$net2ftp_messages["Changing to the directory %1\$s: "] = "ndrar till bibliotek %1\$s: ";
$net2ftp_messages["Character encoding: "] = "Character encoding: ";
$net2ftp_messages["Check the SSH server's public key fingerprint"] = "Check the SSH server's public key fingerprint";
$net2ftp_messages["Checking files"] = "Kontrollerar filer";
$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "Kontrollerar om FTP modul i PHP r installerad: ";
$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "Kontrollerar rttigheter fr biblioteket p webbservern: en liten fil kommer skrivas till /temp mappen och sen raderas.";
$net2ftp_messages["Chmod"] = "Chmod";
$net2ftp_messages["Chmod also the files within this directory"] = "Chmod ven filer i detta bibliotek";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "Chmod ven underbibliotek i detta bibliotek";
$net2ftp_messages["Chmod directories and files"] = "Chmod bibliotek och filer";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "Chmod valda inmatningar (fungerar endast p Unix/Linux/BSD serverar)";
$net2ftp_messages["Choose"] = "Vlj";
$net2ftp_messages["Choose a directory"] = "Vlj bibliotek";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "Klicka fr att sortera efter %1\$s i stigande ordning";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "Klicka fr att sortera efter %1\$s i fallande ordning";
$net2ftp_messages["Closing the file: "] = "Stnger filen: ";
$net2ftp_messages["Connecting to a test FTP server: "] = "Ansluter till en test FTP server: ";
$net2ftp_messages["Connecting to the FTP server"] = "Ansluter till FTP server";
$net2ftp_messages["Connecting to the FTP server: "] = "Ansluter till FTP servern: ";
$net2ftp_messages["Connection from net2ftp server to Google captcha server failed"] = "Connection from net2ftp server to Google captcha server failed";
$net2ftp_messages["Connection settings:"] = "Anslutningsinstllningar:";
$net2ftp_messages["Continue"] = "Fortstt";
$net2ftp_messages["Copied file %1\$s"] = "Kopierade fil %1\$s";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Copied file <b>%1\$s</b>";
$net2ftp_messages["Copy"] = "Kopiera";
$net2ftp_messages["Copy directories and files"] = "Kopiera bibliotek och filer";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "Kopiera bibliotek <b>%1\$s</b> till:";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "Kopiera fil <b>%1\$s</b> till:";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "Kopiera symlink <b>%1\$s</b> till:";
$net2ftp_messages["Copy the selected entries"] = "Kopiera valda inmatningar";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Kopierar net2ftp instalationsscript till FTP server";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Could not connect to SSH server"] = "Could not connect to SSH server";
$net2ftp_messages["Could not copy file %1\$s"] = "Kunde inte kopiera fil %1\$s";
$net2ftp_messages["Could not create directory %1\$s"] = "Kunde inte skapa bibliotek %1\$s";
$net2ftp_messages["Could not generate a temporary file."] = "Kunde inte skapa temporr fil.";
$net2ftp_messages["Could not get fingerprint"] = "Could not get fingerprint";
$net2ftp_messages["Could not get public host key"] = "Could not get public host key";
$net2ftp_messages["Could not unzip entry %1\$s (error code %2\$s)"] = "Could not unzip entry %1\$s (error code %2\$s)";
$net2ftp_messages["Create a new file in directory %1\$s"] = "Skapa ny fil i bibliotek %1\$s";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Skapa webbsida ltt med frdiga mallar";
$net2ftp_messages["Create new directories"] = "Skapa nya bibliotek";
$net2ftp_messages["Create the MySQL database tables"] = "Skapa MySQL databastabell";
$net2ftp_messages["Created directory %1\$s"] = "Skapade bibliotek %1\$s";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Skapat mlunderbibliotek <b>%1\$s</b>";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Skapar temporrt bibliotek p FTP server";
$net2ftp_messages["Creating filename: "] = "Skapar filenamn: ";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "Daglig grns uppndd: filen <b>%1\$s</b> kommer inte verfras";
$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "Daglig grns uppndd: du kommer inte kunna verfra data";
$net2ftp_messages["Data transferred from this IP address today"] = "Data transferred from this IP address today";
$net2ftp_messages["Data transferred to this FTP server today"] = "Data transferred to this FTP server today";
$net2ftp_messages["Date from:"] = "Datum frn:";
$net2ftp_messages["Dear,"] = "Kra,";
$net2ftp_messages["Decompressing archives and transferring files"] = "Dekomprimerar arkiv och verfr filer";
$net2ftp_messages["Default"] = "Frvalt";
$net2ftp_messages["Delete"] = "Radera";
$net2ftp_messages["Delete directories and files"] = "Radera bibliotek och filer";
$net2ftp_messages["Delete the selected entries"] = "Radera valda inmatningar";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "Raderade filen <b>%1\$s</b>";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "Raderat underbibliotek <b>%1\$s</b>";
$net2ftp_messages["Deleting the file: "] = "Raderar filen: ";
$net2ftp_messages["Descending order"] = "Fallande ordning";
$net2ftp_messages["Details"] = "Details";
$net2ftp_messages["Different target FTP server:"] = "Annan mlFTP server:";
$net2ftp_messages["Directories"] = "Bibliotek";
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "Bibliotek med namn som innehller \' kan inte visas korrekt. De kan bara raderas. Backa och vlj ett annat underbibliotek.";
$net2ftp_messages["Directory"] = "Bibliotek";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "Bibliotek <b>%1\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "Bibliotek <b>%1\$s</b> kunde inte skapas.";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "Bibliotek <b>%1\$s</b> framgngsrikt chmodded till <b>%2\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "Bibliotek <b>%1\$s</b> skapades framgngsrikt.";
$net2ftp_messages["Directory Tree"] = "Bibliotek";
$net2ftp_messages["Disabled"] = "Avstngd";
$net2ftp_messages["Double-click to go to a subdirectory:"] = "Dubbel-klicka fr attg till underbibliotek:";
$net2ftp_messages["Download"] = "Download";
$net2ftp_messages["Download a zip file containing all selected entries"] = "Ladda ner en zip fil innehllande alla valda inmatningar";
$net2ftp_messages["Download the file %1\$s"] = "Ladda ner filen %1\$s";
$net2ftp_messages["Drag and drop one of the links below to the bookmarks bar"] = "Drag and drop one of the links below to the bookmarks bar";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Pga tekniska problem kunde inte email till <b>%1\$s</b> skickas.";
$net2ftp_messages["Edit"] = "ndra";
$net2ftp_messages["Edit the source code of file %1\$s"] = "ndra kllkod fr fil %1\$s";
$net2ftp_messages["Email is too long; please enter less than 255 characters."] = "Email is too long; please enter less than 255 characters.";
$net2ftp_messages["Email the zip file in attachment to:"] = "Email zip fil som bilaga till:";
$net2ftp_messages["Empty logs"] = "Tm logg";
$net2ftp_messages["Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21"] = "Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21";
$net2ftp_messages["Enter your email address"] = "Enter your email address";
$net2ftp_messages["Enter your password"] = "Enter your password";
$net2ftp_messages["Enter your username"] = "Enter your username";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp.";
$net2ftp_messages["Example"] = "Exempel";
$net2ftp_messages["Executable"] = "Executable";
$net2ftp_messages["Execute %1\$s in a new window"] = "Utfr %1\$s i ett nytt fnster";
$net2ftp_messages["FTP mode"] = "FTP mode";
$net2ftp_messages["FTP server"] = "FTP server";
$net2ftp_messages["FTP server name is too long; please enter less than 255 characters."] = "FTP server name is too long; please enter less than 255 characters.";
$net2ftp_messages["FTP server port"] = "FTP server port";
$net2ftp_messages["FTP server response:"] = "FTP server svar:";
$net2ftp_messages["File"] = "Fil";
$net2ftp_messages["File <b>%1\$s</b>"] = "Fil <b>%1\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "Filen <b>%1\$s</b> kunde inte flyttas";
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "Filen <b>%1\$s</b> kunde inte verfras till FTP servern";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "Filen <b>%1\$s</b> har verfrts till FTP servern med FTP mode <b>%2\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "Filen <b>%1\$s</b> r OK";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded.";
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "Filen <b>%1\$s</b> r fr stor. Denna fil kommer inte att laddas upp.";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "Fil <b>%1\$s</b> framgngsrikt chmodded till <b>%2\$s</b>";
$net2ftp_messages["File: "] = "Fil: ";
$net2ftp_messages["Files"] = "Filer";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Filer inmatade hr kommer verfras till FTP servern.";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted.";
$net2ftp_messages["Find files which contain a particular word"] = "Hitta filer som innehller ett srskillt ord";
$net2ftp_messages["Fingerprint"] = "Fingerprint";
$net2ftp_messages["Follow symlink %1\$s"] = "Flj symlink %1\$s";
$net2ftp_messages["Font file"] = "Font fil";
$net2ftp_messages["Forums"] = "Forum";
$net2ftp_messages["GIF file"] = "GIF fil";
$net2ftp_messages["GIMP file"] = "GIMP fil";
$net2ftp_messages["GZ archive"] = "GZ arkiv";
$net2ftp_messages["Get fingerprint"] = "Get fingerprint";
$net2ftp_messages["Get the SSH server's public key fingerprint before logging in to verify the server's identity"] = "Get the SSH server's public key fingerprint before logging in to verify the server's identity";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Mottar arkiv %1\$s av %2\$s frn FTP server";
$net2ftp_messages["Getting fingerprint, please wait..."] = "Getting fingerprint, please wait...";
$net2ftp_messages["Getting the FTP server system type: "] = "Mottar FTP server system typ: ";
$net2ftp_messages["Getting the FTP system type"] = "Mottar FTP system typ";
$net2ftp_messages["Getting the current directory"] = "Mottar aktuellt bibliotek";
$net2ftp_messages["Getting the list of directories and files"] = "Mottar lista med bibliotek och filer";
$net2ftp_messages["Getting the raw list of directories and files: "] = "Mottar rlista med bibliotek och filer: ";
$net2ftp_messages["Go"] = "Kr";
$net2ftp_messages["Go back"] = "Go back";
$net2ftp_messages["Go to the advanced functions"] = "G till avancerade funktioner";
$net2ftp_messages["Go to the login page"] = "G till login sidan";
$net2ftp_messages["Go to the parent directory"] = "G till huvudbibliotek";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "G till underbibliotek %1\$s";
$net2ftp_messages["Group"] = "Grupp";
$net2ftp_messages["HTML file"] = "HTML fil";
$net2ftp_messages["HTML templates"] = "HTML mallar";
$net2ftp_messages["Help"] = "Hjlp";
$net2ftp_messages["Help Guide"] = "Hjlp Guide";
$net2ftp_messages["IP address: "] = "IP adress: ";
$net2ftp_messages["Icons"] = "Ikoner";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Om destinationsfil redan finns, kommer den skrivas ver";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "Om du inte knner till detta eller litar p den personen, radera detta email utan att ppna bifogad Zip fil.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "Behver du obegrnsat anvndande, Installera net2ftp p din egen webbserver.";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "Om du verkligen vill att net2ftp ska kunna hantera stora uppgifter som tar lngre tid, vervg att installera net2ftp p din egen server.";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "Om du vill kopiera filerna till en annan FTP server, ange dina inloggningsuppgifter.";
$net2ftp_messages["Image"] = "Bild";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "Fr att garantera rttvist anvndande av webbservern fr alla, r dataverfringsvolymer och scriptkrningar begrnsade fr alla anvndare och per dag. Vid uppndd grns kan du fortfarande navigera p FTP servern men inte verfra data till/frn den.";
$net2ftp_messages["In order to run it, click on the link below."] = "Fr att kra det, klicka p lnken nedan.";
$net2ftp_messages["Information about the sender: "] = "Information om avsndaren: ";
$net2ftp_messages["Initial directory"] = "Initialt bibliotek";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Install software packages"] = "Installera mjukvarupaket";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Installera mjukvarupaket (krver PHP p webbservern)";
$net2ftp_messages["JPEG file"] = "JPEG fil";
$net2ftp_messages["Java Upload"] = "Java Upload";
$net2ftp_messages["Java source file"] = "Java source fil";
$net2ftp_messages["JavaScript file"] = "JavaScript fil";
$net2ftp_messages["Language:"] = "Sprk:";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Lmna tomt om du vill kopiera filerna till samma FTP server.";
$net2ftp_messages["License"] = "Licens";
$net2ftp_messages["Line"] = "Rad";
$net2ftp_messages["List"] = "Lista";
$net2ftp_messages["List of commands:"] = "Lista med kommandon:";
$net2ftp_messages["Logging"] = "Loggar";
$net2ftp_messages["Logging into the FTP server"] = "Loggar in p FTP server";
$net2ftp_messages["Logging into the FTP server: "] = "Loggar in p FTP servern: ";
$net2ftp_messages["Logging out of the FTP server"] = "Loggar ut frn FTP server";
$net2ftp_messages["Login"] = "Logga in";
$net2ftp_messages["Login!"] = "Login!";
$net2ftp_messages["Logout"] = "Logga ut";
$net2ftp_messages["MOV movie file"] = "MOV film fil";
$net2ftp_messages["MPEG movie file"] = "MPEG film fil";
$net2ftp_messages["MS Office - Access database"] = "MS Office - Access databas";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Excel kalkylblad";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - PowerPoint presentation";
$net2ftp_messages["MS Office - Project file"] = "MS Office - Projekt fil";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Visio drawing";
$net2ftp_messages["MS Office - Word document"] = "MS Office - Word dokument";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "Skapa nytt underbibliotek i bibliotek %1\$s";
$net2ftp_messages["Message of the sender: "] = "Meddelande frn avsndaren: ";
$net2ftp_messages["Mobile"] = "Mobile";
$net2ftp_messages["Mod Time"] = "Mod Tid";
$net2ftp_messages["Move"] = "Flytta";
$net2ftp_messages["Move directories and files"] = "Flytta bibliotek och filer";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "Flytta bibliotek <b>%1\$s</b> till:";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "Flytta fil <b>%1\$s</b> till:";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "Flytta symlink <b>%1\$s</b> till:";
$net2ftp_messages["Move the selected entries"] = "Flytta valda inmatningar";
$net2ftp_messages["Moved directory <b>%1\$s</b>"] = "Moved directory <b>%1\$s</b>";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "Flyttade fil <b>%1\$s</b>";
$net2ftp_messages["MySQL database"] = "MySQL databas";
$net2ftp_messages["MySQL password"] = "MySQL lsenord";
$net2ftp_messages["MySQL password length"] = "MySQL lsenord lngd";
$net2ftp_messages["MySQL server"] = "MySQL server";
$net2ftp_messages["MySQL username"] = "MySQL anvndarnamn";
$net2ftp_messages["Name"] = "Namn";
$net2ftp_messages["New dir"] = "Nytt dir";
$net2ftp_messages["New directory name:"] = "Nytt biblioteks namn:";
$net2ftp_messages["New file"] = "Ny fil";
$net2ftp_messages["New file name: "] = "Nytt filnamn: ";
$net2ftp_messages["New name: "] = "Nytt namn: ";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Kom ihg att om du inte ppnar Zip filen, kan inte filer inuti ziparkivet skada din dator.";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "Notera att skicka filer ej r anonymt: din IP adress och tid vid avsndande lggs till i e-mailet.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "Notering: andra anvndare p denna dator kan anvnda webblsarens baktknapp och komma in p FTP servern.";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Notering: mlbiblioteket mste vara skapat innan ngot kan kopieras in i det.";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "Anmrkning: nr du anvnder detta bokmrke, kommer ett popup fnster ppnas och frga efter anvndarnamn och lsenord.";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["OK. Filename: %1\$s"] = "OK. Filnamn: %1\$s";
$net2ftp_messages["Old name: "] = "Gammalt namn: ";
$net2ftp_messages["One click access (net2ftp won't ask for a password - less safe)"] = "One click access (net2ftp won't ask for a password - less safe)";
$net2ftp_messages["Open"] = "ppna";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 kalkylblad";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Calc 6.0 mall";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Draw 6.0 dokument";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Draw 6.0 mall";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 presentation";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Impress 6.0 mall";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Math 6.0 dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Writer 6.0 dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Writer 6.0 global dokument";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Writer 6.0 mall";
$net2ftp_messages["Opening the file in write mode: "] = "ppnar filen i skrivlge: ";
$net2ftp_messages["Owner"] = "gare";
$net2ftp_messages["PHP Source"] = "PHP Source";
$net2ftp_messages["PHP script"] = "PHP script";
$net2ftp_messages["PNG file"] = "PNG fil";
$net2ftp_messages["Parsing the file"] = "Analyserar filen";
$net2ftp_messages["Parsing the list of directories and files"] = "Analyserar listan med bibliotek och filer";
$net2ftp_messages["Passive mode"] = "Passive mode";
$net2ftp_messages["Password"] = "Lsenord";
$net2ftp_messages["Password length"] = "Lsenord lngd";
$net2ftp_messages["Perms"] = "Rttigh";
$net2ftp_messages["Please agree to all privacy policies."] = "Please agree to all privacy policies.";
$net2ftp_messages["Please enter a password."] = "Skriv in lsenord.";
$net2ftp_messages["Please enter a username."] = "Skriv in anvndarnamn.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Skriv in giltigt datum i -m-d format i \"frn\" textruta.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Skriv in giltigt datum i -m-d format i \"till\" textruta.";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "Skriv in giltig storlek i \"frn\" textruta, till exempel 0.";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "Skriv in giltig storlek i \"till\" textruta, till exempel 500000.";
$net2ftp_messages["Please enter a valid filename."] = "Skriv in giltigt filnamn.";
$net2ftp_messages["Please enter a valid search word or phrase."] = "Skriv in giltigt skord eller fras.";
$net2ftp_messages["Please enter an FTP server."] = "Skriv in FTP server.";
$net2ftp_messages["Please enter your Administrator username and password."] = "Skriv in ditt Administratrs anvndarnamn och lsenord.";
$net2ftp_messages["Please enter your MySQL settings:"] = "Fyll i dina MySQL instllningar:";
$net2ftp_messages["Please enter your email address as identifier to give you the right of access and erasure:"] = "Please enter your email address as identifier to give you the right of access and erasure:";
$net2ftp_messages["Please enter your email address."] = "Please enter your email address.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Please enter your username and password for FTP server <b>%1\$s</b>.";
$net2ftp_messages["Please specify a filename"] = "Specificera filnamn";
$net2ftp_messages["Please wait..."] = "Vnta...";
$net2ftp_messages["Powered by"] = "Powered by";
$net2ftp_messages["Printing the list of directories and files"] = "Skriver ut lista med bibliotek och filer";
$net2ftp_messages["Printing the result"] = "Skriver ut resultat";
$net2ftp_messages["Privacy notices"] = "Privacy notices";
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "Bearbetar arkiv nr %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "Bearbetar bibliotek <b>%1\$s</b>";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "Bearbetar inmatningar i biblioteket <b>%1\$s</b>:";
$net2ftp_messages["Processing entry %1\$s"] = "Bearbetar inmatning %1\$s";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "Bearbetande av bibliotek <b>%1\$s</b> frdigt";
$net2ftp_messages["Processing the entries"] = "Bearbetar inmatningarna";
$net2ftp_messages["Protocol"] = "Protocol";
$net2ftp_messages["Quicktime movie file"] = "Quicktime film fil";
$net2ftp_messages["RPM"] = "RPM";
$net2ftp_messages["Reading the file"] = "Lser filen";
$net2ftp_messages["Real movie file"] = "Real film fil";
$net2ftp_messages["Refresh"] = "Uppdatera";
$net2ftp_messages["Rename"] = "Byt namn";
$net2ftp_messages["Rename directories and files"] = "Byt namn p bibliotek och filer";
$net2ftp_messages["Rename the selected entries"] = "Dp om valda inmatningar";
$net2ftp_messages["Requested files"] = "Begrd fil";
$net2ftp_messages["Restrict the search to:"] = "Begrnsa skningen till:";
$net2ftp_messages["Restrictions:"] = "Begrnsningar:";
$net2ftp_messages["Results:"] = "Resultat:";
$net2ftp_messages["Right-click on one of the links below and choose \"Add to Favorites...\""] = "Right-click on one of the links below and choose \"Add to Favorites...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark This Link...\""] = "Right-click on one of the links below and choose \"Bookmark This Link...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark link...\""] = "Right-click on one of the links below and choose \"Bookmark link...\"";
$net2ftp_messages["Right-click on one the links below and choose \"Add Link to Bookmarks...\""] = "Right-click on one the links below and choose \"Add Link to Bookmarks...\"";
$net2ftp_messages["SSH fingerprint"] = "SSH fingerprint";
$net2ftp_messages["SSH server"] = "SSH server";
$net2ftp_messages["Save"] = "Spara";
$net2ftp_messages["Save the zip file on the FTP server as:"] = "Spara zip fil p FTP servern som:";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";
$net2ftp_messages["Script finished in %1\$s seconds"] = "Script avslutat efter %1\$s sekunder";
$net2ftp_messages["Script halted"] = "Script pausat";
$net2ftp_messages["Search"] = "Sk";
$net2ftp_messages["Search directories and files"] = "Sk bibliotek och filer";
$net2ftp_messages["Search for a word or phrase"] = "Sk ord eller fras";
$net2ftp_messages["Search results"] = "Skresultat";
$net2ftp_messages["Searching the files..."] = "Letar efter filer...";
$net2ftp_messages["Select the directory %1\$s"] = "Vlj bibliotek %1\$s";
$net2ftp_messages["Select the file %1\$s"] = "Vlj filen %1\$s";
$net2ftp_messages["Select the symlink %1\$s"] = "Vlj symlink %1\$s";
$net2ftp_messages["Send arbitrary FTP commands"] = "Skicka slumpmssig FTP kommando";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "Skicka godtyckligt FTP kommando till FTP servern";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "Skickar FTP order %1\$s of %2\$s";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Skickat via net2ftp applikationen installerad p denna webbsida: ";
$net2ftp_messages["Set all permissions"] = "Stll in alla behrigheter";
$net2ftp_messages["Set all targetdirectories"] = "Ange mlbibliotek";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "Stll in behrigheter fr bibliotek <b>%1\$s</b> till: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "Stll in behrigheter fr fil <b>%1\$s</b> till: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "Stll in behrigheter fr symlink <b>%1\$s</b> till: ";
$net2ftp_messages["Setting the passive mode"] = "Stller in passive mode";
$net2ftp_messages["Setting the passive mode: "] = "Stller in passive mode: ";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Stller in rttigheter fr temporrt bibliotek";
$net2ftp_messages["Settings used:"] = "Anvnda instllningar:";
$net2ftp_messages["Setup MySQL tables"] = "Setup MySQL tabell";
$net2ftp_messages["Shell script"] = "Shell script";
$net2ftp_messages["Shockwave file"] = "Shockwave fil";
$net2ftp_messages["Shockwave flash file"] = "Shockwave flash fil";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "r denna lnk fel, skriv URL manuellt i din webblsare.";
$net2ftp_messages["Size"] = "Storlek";
$net2ftp_messages["Size of selected directories and files"] = "Storlek av valda bibliotek och filer";
$net2ftp_messages["Skin:"] = "Skin:";
$net2ftp_messages["Some additional comments to add in the email:"] = "Lgg till vriga kommentarer i email:";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Ngon har begrt att filen i bilagan skickas till denna emailadress (%1\$s).";
$net2ftp_messages["Standard"] = "Standard";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x kalkylblad";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - StarChart 5.x dokument";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - StarDraw 5.x dokument";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x presentation";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress Packed 5.x fil";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x mail fil";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - StarMath 5.x dokument";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - StarWriter 5.x dokument";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - StarWriter 5.x global dokument";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "Status: <b>Denna fil kunde inte sparas</b>";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "Status: Sparad p <b>%1\$s</b> med mode %2\$s";
$net2ftp_messages["Status: This file has not yet been saved"] = "Status: Denna fil r inte sparad";
$net2ftp_messages["Submit"] = "Skicka in";
$net2ftp_messages["Symlink"] = "Symlink";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "Symlink <b>%1\$s</b>";
$net2ftp_messages["Symlinks"] = "Symlinks";
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>"] = "Syntax markerad powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>";
$net2ftp_messages["TAR archive"] = "TAR arkiv";
$net2ftp_messages["TIF file"] = "TIF fil";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "Table net2ftp_log_access contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "Table net2ftp_log_access could not be updated.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "Tabell net2ftp_log_consumption_ftpserver inehller dubblettinmatningar.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "Tabell net2ftp_log_consumption_ftpserver inehller dubblettrader.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "Tabell net2ftp_log_consumption_ftpserver kunde inte uppdateras.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "Tabell net2ftp_log_consumption_ipaddress inehller dubblettinmatningar.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "Tabell net2ftp_log_consumption_ipaddress inehller dubblettrader.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "Tabell net2ftp_log_consumption_ipaddress kunde inte uppdateras.";
$net2ftp_messages["Table net2ftp_log_status contains duplicate entries."] = "Table net2ftp_log_status contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_status could not be updated."] = "Table net2ftp_log_status could not be updated.";
$net2ftp_messages["Target directory:"] = "Mlbibliotek:";
$net2ftp_messages["Target name:"] = "Mlnamn:";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "Testa net2ftp listanalysregler";
$net2ftp_messages["Testing the FTP functions"] = "Testar FTP funktioner";
$net2ftp_messages["Text file"] = "Text fil";
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />"] = "The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />";
$net2ftp_messages["The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />"] = "The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "FTP servern <b>%1\$s</b> finns i listan med bannlysta FTP servers.";
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "FTP servern <b>%1\$s</b> finns inte i listan  med tilltna FTP servers.";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "FTP server porten %1\$s fr inte anvndas.";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP transfer mode (ASCII eller BINARY) kommer automatiskt bestmmas, baserat p filenamnsndelse";
$net2ftp_messages["The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />"] = "The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "Chmod nr <b>%1\$s</b> r utanfr intervallet 000-777. Frsk igen.";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The directory <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "Biblioteket <b>%1\$s</b> kunde inte vljas - du kanske inte har rttigheter att se detta bibliotek, eller s existerar det inte.";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "Biblioteket <b>%1\$s</b> kunde inte vljas, s detta bibliotek skapas inte";
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "Biblioteket <b>%1\$s</b> existerar inte eller kunde inte vljas, s biblioteket <b>%2\$s</b> visas istllet.";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "Email adressen du angav (%1\$s) verkar inte vara giltig.<br />Ange en adress i formatet <b>anvndarnamn@domn.com</b>";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The file <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "Filen <b>%1\$s</b> r fr stor fr att kopieras, s denna fil skapas inte";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "Filen <b>%1\$s</b> r fr stor fr att flyttas, avbryter flytt";
$net2ftp_messages["The file is too big to be transferred"] = "The file is too big to be transferred";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "Information om senaste version kunde inte laddas ner frn net2ftp.coms server. Kontrollera skerhetsinstllningarna i din webblsare, dessa kan hindra nedladdning av en liten fil frn net2ftp.coms server.";
$net2ftp_messages["The log tables could not be copied."] = "The log tables could not be copied.";
$net2ftp_messages["The log tables could not be renamed."] = "The log tables could not be renamed.";
$net2ftp_messages["The log tables were copied successfully."] = "The log tables were copied successfully.";
$net2ftp_messages["The log tables were renamed successfully."] = "The log tables were renamed successfully.";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Maximal exekveringstid r <b>%1\$s sekunder</b>";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>"] = "Maximal storlek fr en fil r begrnsad av net2ftp till <b>%1\$s</b> och av PHP till <b>%2\$s</b>";
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "net2ftp installationsscript har kopierats till FTP servern.";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "De nya biblioteken kommer skapas i <b>%1\$s</b>.";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "Det nya namnet fr inte innehlla punkter. Denna inmatning dptes om till <b>%1\$s</b>";
$net2ftp_messages["The number of files which were skipped is:"] = "Antal filer som hoppades ver r:";
$net2ftp_messages["The oldest log table could not be dropped."] = "The oldest log table could not be dropped.";
$net2ftp_messages["The oldest log table was dropped successfully."] = "The oldest log table was dropped successfully.";
$net2ftp_messages["The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment)."] = "The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment).";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "Tabellen <b>%1\$s</b> kunde inte tmmas.";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "Tabellen <b>%1\$s</b> kunde inte optimeras.";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "Tabellen <b>%1\$s</b> tmdes.";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "Tabellen <b>%1\$s</b> optimerades.";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "Mlbibliotek <b>%1\$s</b> r samma som eller ett underbibliotek till kllbiblioteket <b>%2\$s</b>, s detta bibliotek skapas inte";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "Mlet fr filen <b>%1\$s</b> r samma som kllan, s denna fil skapas inte";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "Den uppgift du ville utfra med net2ftp tog lngre tid n tilltna %1\$s sekunder, drfr stoppades uppgiften.";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "Total storlek av valda bibliotek och filer r:";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "Variabeln <b>consumption_ipaddress_datatransfer</b> r inte numerisk.";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "Ordet <b>%1\$s</b> hittades i fljande filer:";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "Ordet <b>%1\$s</b> hittades inte i de valda biblioteken och filerna.";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "Zip filen har sparats p FTP servern som <b>%1\$s</b>";
$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "Zip fil skickad till <b>%1\$s</b>.";
$net2ftp_messages["This SQL query is going to be executed:"] = "Denna SQL frga kommer utfras:";
$net2ftp_messages["This file is not accessible from the web"] = "Ingen tkomst av denna fil frn webben";
$net2ftp_messages["This folder is empty"] = "Denna mapp r tom";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "Denna funktion har stngts av Administratorn fr denna websida.";
$net2ftp_messages["This function is available on PHP 5 only"] = "Denna funktion r endast tillgnglig med PHP 5";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "Detta script krs p din webbserver och krver att PHP installeras.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "Denna tidsgrns garanterar rttvist utnyttjande av webbservern fr alla.";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "Denna version av net2ftp r up-to-date.";
$net2ftp_messages["Time of sending: "] = "Skickat den: ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "Fr att hindra detta mste du stnga alla ppna webblsarfnster.";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "Fr att spara bild, hger-klicka p den och vlj 'Spara bild som...'";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "Fr att stlla in ett vanligt mlbibliotek, ange det mlbiblioteket i textfltet ovan och klicka p knappen \"Ange alla mlbibliotek\".";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\"";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "Fr att stlla in samma vrde p alla behrigheter, Skriv i behrigheter ovanfr och klicka p knappen \"Stll in alla behrigheter\"";
$net2ftp_messages["To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now."] = "To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now.";
$net2ftp_messages["Transferring files to the FTP server"] = "verfr filer till FTP server";
$net2ftp_messages["Transform selected entries: "] = "Omvandla valda inmatningar: ";
$net2ftp_messages["Troubleshoot an FTP server"] = "Felsk en FTP server";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "Felsk net2ftp p denna webbserver";
$net2ftp_messages["Troubleshoot your net2ftp installation"] = "Felsk din net2ftp installation";
$net2ftp_messages["Troubleshooting functions"] = "Felskningsfunktioner";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Frsk dela upp din uppgift i mindre bitar: begrnsa ditt val av filer och uteslut de strsta filerna.";
$net2ftp_messages["Two click access (net2ftp will ask for a password - safer)"] = "Two click access (net2ftp will ask for a password - safer)";
$net2ftp_messages["Type"] = "Typ";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Kunde inte avsluta hanteringen av den temporra filen";
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Kunde inte ansluta till FTP server <b>%1\$s</b> p port <b>%2\$s</b>.<br /><br />r du sker att det r rtt adress till FTP servern? Denna r ofta annorlunda n den till HTTP (web) servern. Kontakta din ISPs support eller systemadministratr fr hjlp.<br />";
$net2ftp_messages["Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Kunde inte ansluta till MySQL databasen. Kontrollera dina MySQL databas instllningar i net2ftp's konfigurationsfil settings.inc.php.";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "Unable to copy the file <b>%1\$s</b>";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "Kunde inte kopiera den lokala filen till fjrrfilen <b>%1\$s</b> med FTP mode <b>%2\$s</b>";
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "Kunde inte kopiera fjrrfilen <b>%1\$s</b> till den lokala filen med FTP mode <b>%2\$s</b>";
$net2ftp_messages["Unable to create a temporary directory (too many tries)"] = "Unable to create a temporary directory (too many tries)";
$net2ftp_messages["Unable to create a temporary directory because (parent directory is not writeable)"] = "Unable to create a temporary directory because (parent directory is not writeable)";
$net2ftp_messages["Unable to create a temporary directory because (unvalid parent directory)"] = "Unable to create a temporary directory because (unvalid parent directory)";
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "Kunde inte skapa biblioteket <b>%1\$s</b>";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "Kunde inte skapa underbibliotek <b>%1\$s</b>. Det kanske redan finns. Fortstter kopiera/flytta processen...";
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "Kunde inte skapa den temporra filen. Kontrollera rttigheter fr %1\$s biblioteket.";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "Kunde inte radera filen <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "Kunde inte radera biblioteket <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "Kunde inte radera filen <b>%1\$s</b>";
$net2ftp_messages["Unable to delete the local file"] = "Kunde inte radera den lokala filen";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "Kunde inte radera underbiblioteket <b>%1\$s</b> - det kan innehlla filer";
$net2ftp_messages["Unable to delete the temporary directory"] = "Kunde inte radera det temporra biblioteket";
$net2ftp_messages["Unable to delete the temporary file"] = "Kunde inte radera den temporra filen";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Kunde inte radera den temporra filen %1\$s";
$net2ftp_messages["Unable to determine your IP address."] = "Kunde inte faststlla din IP address.";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "Kunde inte utfra site command <b>%1\$s</b>";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "Kunde inte utfra site command <b>%1\$s</b>. Notera att CHMOD command bara r tillgngligt p Unix FTP servrar, inte p Windows FTP servrar.";
$net2ftp_messages["Unable to execute the SQL query."] = "Kunde inte utfra SQL frga.";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Kunde inte extrahera filer och bibliotek frn arkivet";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Kunde inte ladda ner arkivet <b>%1\$s</b> frn FTP servern";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "Kunde inte ladda filen <b>%1\$s</b> frn FTP servern och spara den som temporr fil <b>%2\$s</b>.<br />Kontrollera rttigheter fr %3\$s biblioteket.<br />";
$net2ftp_messages["Unable to get the list of packages"] = "Kunde inte motta lisa med paket";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Kunde inte logga in p FTP servern <b>%1\$s</b> med anvndarnamn <b>%2\$s</b>.<br /><br />r du sker att ditt anvndarnamn och lsenord r korrekt? Kontakta din ISPs support eller systemadministratr fr hjlp.<br />";
$net2ftp_messages["Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to move the directory <b>%1\$s</b>"] = "Unable to move the directory <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>"] = "Unable to move the file <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Unable to move the file <b>%1\$s</b>, aborting the move";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "Kunde inte flytta den uppladdade filen till temporrt bibliotek.<br /><br />Administratren fr denna webbsida mste <b>chmod 777</b> /temp biblioteket av net2ftp.";
$net2ftp_messages["Unable to open the system log."] = "Unable to open the system log.";
$net2ftp_messages["Unable to open the template file"] = "Kunde inte ppna mallfilen";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Kunde inte ppna den temporra filen. Kontrollera rttigheter fr %1\$s biblioteket.";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "Kunde inte placera filen <b>%1\$s</b> p FTP servern.<br />Du kanske inte har rttigheter att skriva till biblioteket.";
$net2ftp_messages["Unable to read the template file"] = "kunde inte lsa mallfilen";
$net2ftp_messages["Unable to read the temporary file"] = "Kunde inte lsa den temporra filen";
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "Kunde inte dpa om bibliotek eller fil <b>%1\$s</b> till <b>%2\$s</b>";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Kunde inte vlja MySQL databas. Kontrollera dina MySQL databas instllningar i net2ftp's konfigurationsfil settings.inc.php.";
$net2ftp_messages["Unable to send the file to the browser"] = "Kunde inte skicka filen till webblsaren";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "Kunde inte vlja passive mode p FTP servern <b>%1\$s</b>.";
$net2ftp_messages["Unable to write a message to the system log."] = "Unable to write a message to the system log.";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "Kunde inte skriva raden till den temporra filen <b>%1\$s</b>.<br />Kontrollera rttigheter fr %2\$s biblioteket.";
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "Ovntad meddelande rad: %1\$s. Avslutar.";
$net2ftp_messages["Unrecognized FTP output"] = "Oknd FTP utdata";
$net2ftp_messages["Unzip"] = "Unzip";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Unzip arkiv <b>%1\$s</b> till:";
$net2ftp_messages["Unzip archives"] = "Unzip arkive";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Unzip valda arkiv p FTP servern";
$net2ftp_messages["Up"] = "Upp";
$net2ftp_messages["Update"] = "Upddatera";
$net2ftp_messages["Upload"] = "Upload";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "Ladda upp ny version av filen %1\$s och frena ndringar";
$net2ftp_messages["Upload directories and files using a Java applet"] = "Ladda upp bibliotek och filer med en Java applet";
$net2ftp_messages["Upload files and archives"] = "Ladda upp filer och arkiv";
$net2ftp_messages["Upload more files and archives"] = "Ladda upp fler filer och arkiv";
$net2ftp_messages["Upload new files in directory %1\$s"] = "Ladda upp nya filer i bibliotek %1\$s";
$net2ftp_messages["Upload to directory:"] = "Ladda upp till bibliotek:";
$net2ftp_messages["Username"] = "Anvndarnamn";
$net2ftp_messages["Username is too long; please enter less than 255 characters."] = "Username is too long; please enter less than 255 characters.";
$net2ftp_messages["Version information"] = "Versions information";
$net2ftp_messages["View"] = "Visa";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Visa Macromedia ShockWave Flash film %1\$s";
$net2ftp_messages["View file %1\$s"] = "Visa fil %1\$s";
$net2ftp_messages["View image %1\$s"] = "Visa bild %1\$s";
$net2ftp_messages["View logs"] = "Visa logg";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "Visa filen %1\$s frn din HTTP webbserver";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Visa markerad kllkod fr fil %1\$s";
$net2ftp_messages["WAV sound file"] = "WAV sound fil";
$net2ftp_messages["Webmaster's email: "] = "Webmaster's email: ";
$net2ftp_messages["Writing some text to the file: "] = "Skriver text till filen: ";
$net2ftp_messages["Wrong username or password. Please try again."] = "Fel anvndarnamn eller lsenord. Frsk igen.";
$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "Du angav inget filnamn fr zipfilen. Backa och ange filnamn.";
$net2ftp_messages["You did not enter your Administrator username or password."] = "Du skrev inte in ditt Administratrs anvndarnamn eller lsenord.";
$net2ftp_messages["You did not provide any file to upload."] = "Du valde ingen fil att ladda upp.";
$net2ftp_messages["You did not provide any text to send by email!"] = "Du skrev ingen text att snda via email!";
$net2ftp_messages["You did not supply a From address."] = "Du skrev ingen Frn adress.";
$net2ftp_messages["You did not supply a To address."] = "Du skrev ingen Till adress.";
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "Din IP address (%1\$s) finns i listan med bannlysta IP addresser.";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Your IP address (%1\$s) is not in the list of allowed IP addresses.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your browser does not support applets, or you have disabled applets in your browser settings."] = "Your browser does not support applets, or you have disabled applets in your browser settings.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "Ditt root bibliotek <b>%1\$s</b> existerar inte eller kunde inte vljas.";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your task was stopped"] = "Din uppgift stoppades";
$net2ftp_messages["Zip"] = "Zip";
$net2ftp_messages["Zip archive"] = "Zip arkiv";
$net2ftp_messages["Zip entries"] = "Zip entries";
$net2ftp_messages["Zip the selected entries to save or email them"] = "Zippa valda inmatningar fr att spara eller skicka med email";
$net2ftp_messages["en"] = "se";
$net2ftp_messages["files which were last modified"] = "filer som var senast ndrade";
$net2ftp_messages["files with a filename like"] = "filer med filnamn som";
$net2ftp_messages["files with a size"] = "filer med storlek";
$net2ftp_messages["from"] = "frn";
$net2ftp_messages["iso-8859-1"] = "iso-8859-1";
$net2ftp_messages["left"] = "left";
$net2ftp_messages["ltr"] = "ltr";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp har frskt bestmma bibliotekskopplingar mellan FTP server och webbserver.";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp r fri programvara, slppt under GNU/GPL licens. Fr mer information, http://www.net2ftp.com.";
$net2ftp_messages["no - please install it!"] = "nej - installera den!";
$net2ftp_messages["not OK"] = "inte OK";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "inte OK. Kontrollera rttigheter fr %1\$s biblioteket";
$net2ftp_messages["right"] = "right";
$net2ftp_messages["to"] = "till";
$net2ftp_messages["to:"] = "till:";
$net2ftp_messages["yes"] = "ja";

?>