<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2018 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a ete copie vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------

$net2ftp_messages["%1\$s File"] = "%1\$s եE;
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(؁E ʬΥɥᥤEƤ餁EʤˤϡΥE󥯤ϵǽޤ)";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> E<b>%2\$s</b> ˲̾EȤϤǤޤE;
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b>  <b>%2\$s</b> ˲̾Eޤ";
$net2ftp_messages["ARC archive"] = "ARC ";
$net2ftp_messages["ARJ archive"] = "ARJ ";
$net2ftp_messages["ASP script"] = "ASP Eץ";
$net2ftp_messages["Action"] = "祁E;
$net2ftp_messages["Actions"] = "ກE;
$net2ftp_messages["Add another"] = "ɲ";
$net2ftp_messages["Adobe Acrobat document"] = "Adobe Acrobat ɥ";
$net2ftp_messages["Advanced"] = "ĥǽ";
$net2ftp_messages["Advanced FTP functions"] = "ĥ FTP ǽ";
$net2ftp_messages["Advanced functions"] = "ĥǽ";
$net2ftp_messages["Advanced login"] = "Advanced login";
$net2ftp_messages["All"] = "";
$net2ftp_messages["All the selected directories and files have been processed."] = "򤵤E٤ƤΥǥEȥꡢեEνλޤ";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "򤵤EǥEȥEΥ֥ǥEȥȥեE⺁EEEޤ!";
$net2ftp_messages["Alternatively, use net2ftp's normal upload or upload-and-unzip functionality."] = "Alternatively, use net2ftp's normal upload or upload-and-unzip functionality.";
$net2ftp_messages["An error has occured"] = "顼Ǥ";
$net2ftp_messages["Anonymous"] = "ƿ̾";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "եEĥҤȽǽʤᡢ̥եE<b>%1\$s</b> ϽEޤǤߥݡȤEƤE̥եE zip, tar, tgz, gz Ǥ";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "Archive contains filenames with ../ or ..\\ - aborting the extraction";
$net2ftp_messages["Archives"] = "̥եE;
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Ϥ̥եEवEΥեE FTP ФžEޤ";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "EΥեEEEƤǤ?";
$net2ftp_messages["Ascending order"] = "E;
$net2ftp_messages["Automatic"] = "ư";
$net2ftp_messages["Back"] = "ᤁE;
$net2ftp_messages["Basic FTP login"] = "Basic FTP login";
$net2ftp_messages["Basic SSH login"] = "Basic SSH login";
$net2ftp_messages["Bitmap file"] = "BMP ᡼";
$net2ftp_messages["Bookmark"] = "֥åޡ";
$net2ftp_messages["Calculate the size of the selected entries"] = "򤵤EȥΥեE׻";
$net2ftp_messages["Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed in the session. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button."] = "Captcha check failed on the login screen. Please return to the login screen and tick the 'I'm not a robot' checkbox before clicking on the 'Login' button.";
$net2ftp_messages["Cascading Style Sheet"] = "CSS E";
$net2ftp_messages["Case sensitive search"] = "ܺٸE;
$net2ftp_messages["Changing the directory"] = "ǥEȥѹƤޤ";
$net2ftp_messages["Changing to the directory %1\$s: "] = "ǥEȥE%1\$s ѹÁE ";
$net2ftp_messages["Character encoding: "] = "Character encoding: ";
$net2ftp_messages["Check the SSH server's public key fingerprint"] = "Check the SSH server's public key fingerprint";
$net2ftp_messages["Checking files"] = "եEå򤷤Ƥޤ";
$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "PHP  FTP⥸塼E󥹥ȡEEƤEĴ٤Ƥޤ: ";
$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "webоΥǥEȥεľĴ٤Ƥޤ: /temp եE˾ʥեEܮEޤǺEEEޤ";
$net2ftp_messages["Chmod"] = "ľѹ";
$net2ftp_messages["Chmod also the files within this directory"] = "ΥǥEȥΥեEѹ";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "ΥǥEȥΥ֥ǥEȥѹ";
$net2ftp_messages["Chmod directories and files"] = "ǥEȥȥեEεľѹ";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "򤵤EȥεľѹUnix/Linux/BSD ФΤͭ";
$net2ftp_messages["Choose"] = "E;
$net2ftp_messages["Choose a directory"] = "ǥEȥE;
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "EåE %1\$s Ǿ祽";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "EåE %1\$s ǹ߽祽";
$net2ftp_messages["Closing the file: "] = "եEĤƤޤ: ";
$net2ftp_messages["Connecting to a test FTP server: "] = "ƥFTPФ³ÁE ";
$net2ftp_messages["Connecting to the FTP server"] = "FTPФ³Ƥޤ";
$net2ftp_messages["Connecting to the FTP server: "] = "FTPФ³ÁE ";
$net2ftp_messages["Connection from net2ftp server to Google captcha server failed"] = "Connection from net2ftp server to Google captcha server failed";
$net2ftp_messages["Connection settings:"] = "³āE";
$net2ftp_messages["Continue"] = "³E;
$net2ftp_messages["Copied file %1\$s"] = "Copied file %1\$s";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "եE<b>%1\$s</b> 򥳥ԡ";
$net2ftp_messages["Copy"] = "ԡ";
$net2ftp_messages["Copy directories and files"] = "ǥEȥȥեEΥԡ";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "ǥEȥE<b>%1\$s</b> ΥԡE";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "եE<b>%1\$s</b> ΥԡE";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "ܥEåE <b>%1\$s</b> ΥԡE";
$net2ftp_messages["Copy the selected entries"] = "򤵤Eȥ򥳥ԡ";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Copying the net2ftp installer script to the FTP server";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Could not connect to SSH server"] = "Could not connect to SSH server";
$net2ftp_messages["Could not copy file %1\$s"] = "Could not copy file %1\$s";
$net2ftp_messages["Could not create directory %1\$s"] = "Could not create directory %1\$s";
$net2ftp_messages["Could not generate a temporary file."] = "EեEEȤǤޤ";
$net2ftp_messages["Could not get fingerprint"] = "Could not get fingerprint";
$net2ftp_messages["Could not get public host key"] = "Could not get public host key";
$net2ftp_messages["Could not unzip entry %1\$s (error code %2\$s)"] = "Could not unzip entry %1\$s (error code %2\$s)";
$net2ftp_messages["Create a new file in directory %1\$s"] = "ǥEȥE%1\$s ˿եEܮ";
$net2ftp_messages["Create a website easily using ready-made templates"] = "ΥƥץEȤѤƴñ webȤܮ";
$net2ftp_messages["Create new directories"] = "ǥEȥκܮ";
$net2ftp_messages["Create the MySQL database tables"] = "MySQL ǡ١ơ֥Eκܮ";
$net2ftp_messages["Created directory %1\$s"] = "Created directory %1\$s";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "оݤΥ֥ǥEȥE<b>%1\$s</b> ܮ";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Creating a temporary directory on the FTP server";
$net2ftp_messages["Creating filename: "] = "եEܮÁE ";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "1ƁE¤ã: եE<b>%1\$s</b> žEޤE;
$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "1ƁEž¤ã: ǡžEȤϤǤޤE;
$net2ftp_messages["Data transferred from this IP address today"] = "Data transferred from this IP address today";
$net2ftp_messages["Data transferred to this FTP server today"] = "Data transferred to this FTP server today";
$net2ftp_messages["Date from:"] = "ƁE:";
$net2ftp_messages["Dear,"] = "Dear,";
$net2ftp_messages["Decompressing archives and transferring files"] = "֤षեEžƤޤ";
$net2ftp_messages["Default"] = "ǥեE";
$net2ftp_messages["Delete"] = "EE;
$net2ftp_messages["Delete directories and files"] = "ǥEȥȥեEκEE;
$net2ftp_messages["Delete the selected entries"] = "򤵤EȥEE;
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "եE<b>%1\$s</b> EE;
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "֥ǥEȥE<b>%1\$s</b> EE;
$net2ftp_messages["Deleting the file: "] = "եEEEƤޤ: ";
$net2ftp_messages["Descending order"] = "߽E;
$net2ftp_messages["Details"] = "ܺ";
$net2ftp_messages["Different target FTP server:"] = "̤о FTP :";
$net2ftp_messages["Directories"] = "ǥEȥE;
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "̾ \' ޤǥEȥɽEޤ󡣺EEEƤޤޤä̤Υ֥ǥEȥ򤷤Ƥ";
$net2ftp_messages["Directory"] = "եE";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "ǥEȥE<b>%1\$s</b>";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "ǥEȥE<b>%1\$s</b> ܮEȤǤޤǤ";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "ǥEȥE<b>%1\$s</b> εľ <b>%2\$s</b> ѹEޤ";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "ǥEȥE<b>%1\$s</b> ܮEޤ";
$net2ftp_messages["Directory Tree"] = "ĥ꡼ɽ";
$net2ftp_messages["Disabled"] = "̵E;
$net2ftp_messages["Double-click to go to a subdirectory:"] = "֥EEåǥ֥ǥEȥذư:";
$net2ftp_messages["Download"] = "";
$net2ftp_messages["Download a zip file containing all selected entries"] = "򤵤Eȥ򤹤٤ƴޤవ̥եE";
$net2ftp_messages["Download the file %1\$s"] = "եE%1\$s Υ";
$net2ftp_messages["Drag and drop one of the links below to the bookmarks bar"] = "Drag and drop one of the links below to the bookmarks bar";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Ū <b>%1\$s</b> ؤ Żҥ᡼EEޤǤ";
$net2ftp_messages["Edit"] = "Խ";
$net2ftp_messages["Edit the source code of file %1\$s"] = "եE%1\$s ΥɤԽ";
$net2ftp_messages["Email is too long; please enter less than 255 characters."] = "Email is too long; please enter less than 255 characters.";
$net2ftp_messages["Email the zip file in attachment to:"] = "Email ˰̥եEź:";
$net2ftp_messages["Empty logs"] = "ξõE;
$net2ftp_messages["Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21"] = "Enter the FTP server port (21 for FTP, 22 for FTP SSH or 990 for FTP SSL) - if you're not sure leave it to 21";
$net2ftp_messages["Enter your email address"] = "Enter your email address";
$net2ftp_messages["Enter your password"] = "Enter your password";
$net2ftp_messages["Enter your username"] = "Enter your username";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp.";
$net2ftp_messages["Example"] = "΁E;
$net2ftp_messages["Executable"] = "¹ԲǽեE;
$net2ftp_messages["Execute %1\$s in a new window"] = "%1\$s 򿷤ɥǼ¹";
$net2ftp_messages["FTP mode"] = "FTP⡼";
$net2ftp_messages["FTP server"] = "FTP ";
$net2ftp_messages["FTP server name is too long; please enter less than 255 characters."] = "FTP server name is too long; please enter less than 255 characters.";
$net2ftp_messages["FTP server port"] = "FTPХݡ";
$net2ftp_messages["FTP server response:"] = "FTPФαŁE";
$net2ftp_messages["File"] = "եE;
$net2ftp_messages["File <b>%1\$s</b>"] = "եE<b>%1\$s</b>";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "եE<b>%1\$s</b> ϰưǤޤE;
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "եE<b>%1\$s</b> EFTPФžEȤǤޤǤ";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "եE<b>%1\$s</b>  FTP⡼ <b>%2\$s</b> Ѥ FTPФžEޤ";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "եE<b>%1\$s</b>  OK";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded.";
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "եE<b>%1\$s</b> 礭ޤΥեEϥåץɤEޤ";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "եE<b>%1\$s</b> εľ <b>%2\$s</b> ѹEޤ";
$net2ftp_messages["File: "] = "եE ";
$net2ftp_messages["Files"] = "եE;
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "ϤեE FTP ФžEޤ";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted.";
$net2ftp_messages["Find files which contain a particular word"] = "ʸޤեE򸡺E;
$net2ftp_messages["Fingerprint"] = "Fingerprint";
$net2ftp_messages["Follow symlink %1\$s"] = "Follow symlink %1\$s";
$net2ftp_messages["Font file"] = "եȥեE;
$net2ftp_messages["Forums"] = "ե饁E;
$net2ftp_messages["GIF file"] = "GIF ᡼";
$net2ftp_messages["GIMP file"] = "GIMP ͥƥ֥᡼եޥå";
$net2ftp_messages["GZ archive"] = "Gzip եE;
$net2ftp_messages["Get fingerprint"] = "Get fingerprint";
$net2ftp_messages["Get the SSH server's public key fingerprint before logging in to verify the server's identity"] = "Get the SSH server's public key fingerprint before logging in to verify the server's identity";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Getting archive %1\$s of %2\$s from the FTP server";
$net2ftp_messages["Getting fingerprint, please wait..."] = "Getting fingerprint, please wait...";
$net2ftp_messages["Getting the FTP server system type: "] = "FTPФΥƥ༁E̤ÁE ";
$net2ftp_messages["Getting the FTP system type"] = "FTPƥ༁E̤Ƥޤ";
$net2ftp_messages["Getting the current directory"] = "EȥǥEȥƤޤ";
$net2ftp_messages["Getting the list of directories and files"] = "ǥEȥȥեEΥEȤƤޤ";
$net2ftp_messages["Getting the raw list of directories and files: "] = "ǥEȥȥեEEȤÁE ";
$net2ftp_messages["Go"] = "ư";
$net2ftp_messages["Go back"] = "ᤁE;
$net2ftp_messages["Go to the advanced functions"] = "ĥǽβ̤򳫤";
$net2ftp_messages["Go to the login page"] = "ڡᤁE;
$net2ftp_messages["Go to the parent directory"] = "ҤȤľذư";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "֥ǥEȥE%1\$s ذư";
$net2ftp_messages["Group"] = "E";
$net2ftp_messages["HTML file"] = "HTML ɥ";
$net2ftp_messages["HTML templates"] = "HTML ƥץE";
$net2ftp_messages["Help"] = "إE";
$net2ftp_messages["Help Guide"] = "إEץ";
$net2ftp_messages["IP address: "] = "IP address: ";
$net2ftp_messages["Icons"] = "E;
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "žƱ̾ΥեEǤ¸ߤEEϾ񤭤Eޤ";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "̵¤˻Ѥϡʬ webФ net2ftp 򥤥󥹥ȡEƲ";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "⤷ɤƤEnet2ftpȤäĹ礭ʺȤ򤹤EפEEϡʬΥФ net2ftpƳEȤƤƲ";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "̤ FTP Ф˥եE򥳥ԡEȤϡʤΥϤƲ";
$net2ftp_messages["Image"] = "E;
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "webФͤǸʿѤEȤݾ㤹Eᡢǡž̤ȥEץȤμ¹Ի֤ϥ桼Ȥ1ƁE̤¤EƤޤ¤ãE礁EFTPФɽEȤϤǤޤǡϤǤޤ";
$net2ftp_messages["In order to run it, click on the link below."] = "In order to run it, click on the link below.";
$net2ftp_messages["Information about the sender: "] = "Information about the sender: ";
$net2ftp_messages["Initial directory"] = "鴁EǥEȥE;
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Install software packages"] = "Install software packages";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Install software packages (requires PHP on web server)";
$net2ftp_messages["JPEG file"] = "JPEG ᡼";
$net2ftp_messages["Java Upload"] = "Java åץ";
$net2ftp_messages["Java source file"] = "Java եE;
$net2ftp_messages["JavaScript file"] = "JavaScript եE;
$net2ftp_messages["Language:"] = "E";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Ʊ FTP Ф˥եE򥳥ԡEȤϡϤʤǲ";
$net2ftp_messages["License"] = "饤";
$net2ftp_messages["Line"] = "";
$net2ftp_messages["List"] = "E";
$net2ftp_messages["List of commands:"] = "ޥɤΥE:";
$net2ftp_messages["Logging"] = "ϿÁE;
$net2ftp_messages["Logging into the FTP server"] = "FTPФ˥󤷤Ƥޤ";
$net2ftp_messages["Logging into the FTP server: "] = "FTPФ˥ÁE ";
$net2ftp_messages["Logging out of the FTP server"] = "FTPФȤƤޤ";
$net2ftp_messages["Login"] = "E;
$net2ftp_messages["Login!"] = "󤷤褦!";
$net2ftp_messages["Logout"] = "";
$net2ftp_messages["MOV movie file"] = "MOV ӥǥ";
$net2ftp_messages["MPEG movie file"] = "MPEG ӥǥ";
$net2ftp_messages["MS Office - Access database"] = "MS Office - Access ǡ١";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Excel E";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - PowerPoint ץEơ祁E;
$net2ftp_messages["MS Office - Project file"] = "MS Office - Project եE;
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Visio ɥ";
$net2ftp_messages["MS Office - Word document"] = "MS Office - Word ɥ";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "ǥEȥE%1\$s β˥֥ǥEȥܮ";
$net2ftp_messages["Message of the sender: "] = "Message of the sender: ";
$net2ftp_messages["Mobile"] = "Mobile";
$net2ftp_messages["Mod Time"] = "ƁE";
$net2ftp_messages["Move"] = "ư";
$net2ftp_messages["Move directories and files"] = "ǥEȥȥեEΰư";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "ǥEȥE<b>%1\$s</b> ΰưE";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "եE<b>%1\$s</b> ΰưE";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "ܥEåE <b>%1\$s</b> ΰưE";
$net2ftp_messages["Move the selected entries"] = "򤵤Eȥư";
$net2ftp_messages["Moved directory <b>%1\$s</b>"] = "Moved directory <b>%1\$s</b>";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "եE<b>%1\$s</b> ư";
$net2ftp_messages["MySQL database"] = "MySQL ǡ١";
$net2ftp_messages["MySQL password"] = "MySQL ѥE";
$net2ftp_messages["MySQL password length"] = "MySQL ѥEĹ";
$net2ftp_messages["MySQL server"] = "MySQL ";
$net2ftp_messages["MySQL username"] = "MySQL 桼̾";
$net2ftp_messages["Name"] = "̾";
$net2ftp_messages["New dir"] = "ǥEȥE;
$net2ftp_messages["New directory name:"] = "ǥEȥE:";
$net2ftp_messages["New file"] = "եE;
$net2ftp_messages["New file name: "] = "եE: ";
$net2ftp_messages["New name: "] = "̾: ";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Note that if you don't open the Zip file, the files inside cannot harm your computer.";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "؁E եEƿ̾ǤEޤ󡣤ʤ IP ɥE email ɲäEޤ";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "؁E ֥饦ᤁEܥ򥯥EåEȡΥԥ塼¾Υ桼 FTPФ˥EȤǤƤޤޤ";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "؁E ԡEˡоݥǥEȥ꤬¸ߤƤʤEФʤޤ";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "؁E Υ֥åޡѤEȡݥåץåץɥǥ桼̾ȥѥEɤϤޤ";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["OK. Filename: %1\$s"] = "OK. եE: %1\$s";
$net2ftp_messages["Old name: "] = "̾: ";
$net2ftp_messages["One click access (net2ftp won't ask for a password - less safe)"] = "One click access (net2ftp won't ask for a password - less safe)";
$net2ftp_messages["Open"] = "";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 ץEåɥ";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Calc 6.0 ƥץE";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Draw 6.0 ɥ";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Draw 6.0 ƥץE";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 ץEơ祁E;
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Impress 6.0 ƥץE";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Math 6.0 ";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Writer 6.0 ƥȥɥ";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Writer 6.0 ޥɥ";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Writer 6.0 ƥץE";
$net2ftp_messages["Opening the file in write mode: "] = "եE񤭹ߥ⡼ɤǳƤޤ: ";
$net2ftp_messages["Owner"] = "E";
$net2ftp_messages["PHP Source"] = "PHP ";
$net2ftp_messages["PHP script"] = "PHP Eץ";
$net2ftp_messages["PNG file"] = "PNG ᡼";
$net2ftp_messages["Parsing the file"] = "եEϤƤޤ";
$net2ftp_messages["Parsing the list of directories and files"] = "ǥEȥȥեEΥEȤϤƤޤ";
$net2ftp_messages["Passive mode"] = "Passive ⡼";
$net2ftp_messages["Password"] = "ѥE";
$net2ftp_messages["Password length"] = "ѥEĹ";
$net2ftp_messages["Perms"] = "ľʁE;
$net2ftp_messages["Please agree to all privacy policies."] = "Please agree to all privacy policies.";
$net2ftp_messages["Please enter a password."] = "ѥEɤϤƲ";
$net2ftp_messages["Please enter a username."] = "桼̾ϤƲ";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Y-m-d ͭƁEդE\"from\" ƥȥܥåϤƲ";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Y-m-d ͭƁEդE\"to\" ƥȥܥåϤƲ";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "ͭʥեEE\"from\" ƥȥܥåϤƲ(΁E 0)";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "ͭʥեEE\"to\" ƥȥܥåϤƲ(΁E 500000)";
$net2ftp_messages["Please enter a valid filename."] = "ͭʥեEϤƤ";
$net2ftp_messages["Please enter a valid search word or phrase."] = "ͭñEޤϸEϤƤ";
$net2ftp_messages["Please enter an FTP server."] = "FTPФϤƲ";
$net2ftp_messages["Please enter your Administrator username and password."] = "ԤΥ桼̾ȥѥEɤϤƲ";
$net2ftp_messages["Please enter your MySQL settings:"] = "ʤ MySQL āEͤϤƤ:";
$net2ftp_messages["Please enter your email address as identifier to give you the right of access and erasure:"] = "Please enter your email address as identifier to give you the right of access and erasure:";
$net2ftp_messages["Please enter your email address."] = "Please enter your email address.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Please enter your username and password for FTP server <b>%1\$s</b>.";
$net2ftp_messages["Please specify a filename"] = "եEꤷƤ";
$net2ftp_messages["Please wait..."] = "Ф餯Ԥ...";
$net2ftp_messages["Powered by"] = "E";
$net2ftp_messages["Printing the list of directories and files"] = "ǥEȥȥեEΥEȤɽƤޤ";
$net2ftp_messages["Printing the result"] = "E̤ϤƤޤ";
$net2ftp_messages["Privacy notices"] = "Privacy notices";
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "̥եEν顼 %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "ǥEȥE<b>%1\$s</b> νÁE;
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "ǥEȥE<b>%1\$s</b> ΥȥƤޤ:";
$net2ftp_messages["Processing entry %1\$s"] = "ȥE%1\$s Ƥޤ";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "ǥEȥE<b>%1\$s</b> νλ";
$net2ftp_messages["Processing the entries"] = "ȥν򤷤Ƥޤ";
$net2ftp_messages["Protocol"] = "Protocol";
$net2ftp_messages["Quicktime movie file"] = "Quicktime ӥǥ";
$net2ftp_messages["RPM"] = "RPM ѥåեE;
$net2ftp_messages["Reading the file"] = "եEɤ߹Ǥޤ";
$net2ftp_messages["Real movie file"] = "EEӥǥ եE;
$net2ftp_messages["Refresh"] = "";
$net2ftp_messages["Rename"] = "̾ѹ";
$net2ftp_messages["Rename directories and files"] = "ǥEȥEȥեEѹ";
$net2ftp_messages["Rename the selected entries"] = "򤵤Eȥ̾ѹ";
$net2ftp_messages["Requested files"] = "Requested files";
$net2ftp_messages["Restrict the search to:"] = ":";
$net2ftp_messages["Restrictions:"] = ":";
$net2ftp_messages["Results:"] = "E:";
$net2ftp_messages["Right-click on one of the links below and choose \"Add to Favorites...\""] = "Right-click on one of the links below and choose \"Add to Favorites...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark This Link...\""] = "Right-click on one of the links below and choose \"Bookmark This Link...\"";
$net2ftp_messages["Right-click on one of the links below and choose \"Bookmark link...\""] = "Right-click on one of the links below and choose \"Bookmark link...\"";
$net2ftp_messages["Right-click on one the links below and choose \"Add Link to Bookmarks...\""] = "Right-click on one the links below and choose \"Add Link to Bookmarks...\"";
$net2ftp_messages["SSH fingerprint"] = "SSH fingerprint";
$net2ftp_messages["SSH server"] = "SSH server";
$net2ftp_messages["Save"] = "¸";
$net2ftp_messages["Save the zip file on the FTP server as:"] = "FTP оǼΥեE򰵽:";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";
$net2ftp_messages["Script finished in %1\$s seconds"] = "EץȤ %1\$s äǽλޤ";
$net2ftp_messages["Script halted"] = "EץȤߤޤ";
$net2ftp_messages["Search"] = "E;
$net2ftp_messages["Search directories and files"] = "եEȥǥEȥ򸡺E;
$net2ftp_messages["Search for a word or phrase"] = "ʸθE;
$net2ftp_messages["Search results"] = "E";
$net2ftp_messages["Searching the files..."] = "եEθÁE..";
$net2ftp_messages["Select the directory %1\$s"] = "ǥEȥE%1\$s E;
$net2ftp_messages["Select the file %1\$s"] = "եE%1\$s E;
$net2ftp_messages["Select the symlink %1\$s"] = "ܥEåE %1\$s E;
$net2ftp_messages["Send arbitrary FTP commands"] = "Ǥդ FTPޥɤ";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "FTPФǤդ FTPޥɤE;
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "FTPޥɤÁE%2\$s  %1\$s";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Sent via the net2ftp application installed on this website: ";
$net2ftp_messages["Set all permissions"] = "āE;
$net2ftp_messages["Set all targetdirectories"] = "ƤоݥǥEȥE;
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "ǥEȥE<b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "եE<b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "ܥEåE <b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Setting the passive mode"] = "ѥå֥⡼ɤ򤷤Ƥޤ";
$net2ftp_messages["Setting the passive mode: "] = "ѥå֥⡼ɤāEE ";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Setting the permissions of the temporary directory";
$net2ftp_messages["Settings used:"] = "ѤEEāE";
$net2ftp_messages["Setup MySQL tables"] = "MySQL ơ֥EāE;
$net2ftp_messages["Shell script"] = "EEץ";
$net2ftp_messages["Shockwave file"] = "Shockwave եE;
$net2ftp_messages["Shockwave flash file"] = "Shockwave flash ǥ";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Should this link not be correct, enter the URL manually in your web browser.";
$net2ftp_messages["Size"] = "";
$net2ftp_messages["Size of selected directories and files"] = "򤵤EǥEȥȥեEΥ";
$net2ftp_messages["Skin:"] = "ơ:";
$net2ftp_messages["Some additional comments to add in the email:"] = "email ɲäE:";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Someone has requested the files in attachment to be sent to this email account (%1\$s).";
$net2ftp_messages["Standard"] = "Standard";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x ץEåɥ";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - StarChart 5.x ɥ";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - StarDraw 5.x ɥ";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x ץEơ祁E;
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress Packed 5.x եE;
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x mail եE;
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - StarMath 5.x ";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - StarWriter 5.x ƥȥɥ";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - StarWriter 5.x ޥɥ";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "ơ: <b>ΥեE¸ǤޤE/b>";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "ơ: %2\$s ⡼ɤ <b>%1\$s</b> ¸Eޤ";
$net2ftp_messages["Status: This file has not yet been saved"] = "ơ: ΥեEϤޤ¸EƤޤE;
$net2ftp_messages["Submit"] = "";
$net2ftp_messages["Symlink"] = "ܥEåE";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "ܥEåE <b>%1\$s</b>";
$net2ftp_messages["Symlinks"] = "ܥEåE";
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://luminous.asgaard.co.uk\">Luminous</a>"] = "դɽ <a href=\"http://luminous.asgaard.co.uk\">Luminous</a> 鶡EEƤޤ";
$net2ftp_messages["TAR archive"] = "TAR ";
$net2ftp_messages["TIF file"] = "TIFF ᡼";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "Table net2ftp_log_access contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "Table net2ftp_log_access could not be updated.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "ơ֥Enet2ftp_log_consumption_ftpserver ˽ʣȥ꤬ޤޤEƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "ơ֥Enet2ftp_log_consumption_ftpserver ˽ʣԤޤޤEƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "ơ֥Enet2ftp_log_consumption_ftpserver ϹԲĤǤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "ơ֥Enet2ftp_log_consumption_ipaddress ˽ʣȥ꤬ޤޤEƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "ơ֥Enet2ftp_log_consumption_ipaddress ˽ʣԤޤޤEƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "ơ֥Enet2ftp_log_consumption_ipaddress ϹԲĤǤ";
$net2ftp_messages["Table net2ftp_log_status contains duplicate entries."] = "Table net2ftp_log_status contains duplicate entries.";
$net2ftp_messages["Table net2ftp_log_status could not be updated."] = "Table net2ftp_log_status could not be updated.";
$net2ftp_messages["Target directory:"] = "оݥǥEȥE";
$net2ftp_messages["Target name:"] = "о̾:";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "net2ftp ΥEȲϥEEƥ";
$net2ftp_messages["Testing the FTP functions"] = "FTPǽƥȤƤޤ";
$net2ftp_messages["Text file"] = "ץEƥ ɥ";
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />"] = "The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a>.<br />";
$net2ftp_messages["The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />"] = "The FTP module of PHP and/or OpenSSL are not installed.<br /><br /> The administrator of this website should install these. Installation instructions are given on php.net: <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module installation</a> and <a href=\"http://php.net/manual/en/openssl.installation.php\">OpenSSL installation</a>.<br />";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "FTP<b>%1\$s</b>ϡ ػߤEFTPФΥEȤäƤޤ";
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "FTP <b>%1\$s</b> ϡĤEFTPФΥEȤäƤޤ";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "FTPХݡ %1\$s ϻѤǤޤ";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP ž⡼ (ASCII ޤ ХʥE ϥեEγĥҤˤäƼưŪ˷ꤵEޤ";
$net2ftp_messages["The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />"] = "The SSH server's fingerprint does not match the fingerprint which was validated previously.<br /><br />Current fingerprint: %1\$s <br />Fingerprint validated previously: %2\$s <br /><br />";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "āEͥ顼: <b>%1\$s</b>  000  777 ͤǤϤޤ󡣺ꤷƲ";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The directory <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "ǥEȥE<b>%1\$s</b> 򤹤EȤǤޤE- ʤˤϤΥǥEȥEʬʻʤʤޤϥǥEȥ꤬¸ߤޤ";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "ǥEȥE<b>%1\$s</b> 򤹤EȤǤޤ󡣤ΥǥEȥϥåפEޤ";
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "ǥEȥE<b>%1\$s</b> ¸ߤʤ򤹤EȤǤޤ󡣥ǥEȥE<b>%2\$s</b> 夁EɽEޤ";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "ϤE email ɥE (%1\$s) ͭǤϤޤ<br />ν񼰤§äɥEϤƲ <b>username@domain.com</b>";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The file <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "The file <b>%1\$s</b> is too big to be copied, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "The file <b>%1\$s</b> is too big to be moved, aborting the move";
$net2ftp_messages["The file is too big to be transferred"] = "The file is too big to be transferred";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "ǿС net2ftp.com Ф鸡EޤǤѤΥ֥饦 net2ftp.com Ф龮եEɤ߹ޤEEΤɻߤƤEEޤ֥饦Υ奁EƥǧƲ";
$net2ftp_messages["The log tables could not be copied."] = "The log tables could not be copied.";
$net2ftp_messages["The log tables could not be renamed."] = "The log tables could not be renamed.";
$net2ftp_messages["The log tables were copied successfully."] = "The log tables were copied successfully.";
$net2ftp_messages["The log tables were renamed successfully."] = "The log tables were renamed successfully.";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "֤ξ¤ <b>%1\$s </b> Ǥ";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s</b> and by PHP to <b>%2\$s</b>"] = "1ĤΥեEξ¥ net2ftp  <b>%1\$s</b> ޤǡ PHP  <b>%2\$s</b> ޤǤ¤EƤޤ";
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "The net2ftp installer script has been copied to the FTP server.";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "ǥEȥ <b>%1\$s</b> ˺ܮEޤ";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "եE˥ɥå(.)ޤळȤϤǤޤ󡣤Υȥ <b>%1\$s</b> ˲̾EޤǤ";
$net2ftp_messages["The number of files which were skipped is:"] = "άEեEθĿE";
$net2ftp_messages["The oldest log table could not be dropped."] = "The oldest log table could not be dropped.";
$net2ftp_messages["The oldest log table was dropped successfully."] = "The oldest log table was dropped successfully.";
$net2ftp_messages["The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment)."] = "The online installation is about 1-2 MB and the offline installation is about 13 MB. This 'end-user' java is called JRE (Java Runtime Environment).";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "ơ֥E<b>%1\$s</b> ˤEȤǤޤǤ";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "ơ֥E<b>%1\$s</b> ŬEȤǤޤǤ";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "ơ֥E<b>%1\$s</b> E˶ˤʤޤ";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "ơ֥E<b>%1\$s</b> E˺ŬEޤ";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "оݤΥǥEȥE<b>%1\$s</b> ϸΥǥEȥE<b>%2\$s</b> Υ֥ǥEȥ꤫ޤƱǥEȥǤΥǥEȥν򥹥åפޤ";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "оݤΥեE<b>%1\$s</b> ϸΥեEƱ̾ǤΥեEν򥹥åפޤ";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "ʤ net2ftpǼ¹Ԥ褦ȤȤϡƻ֤ %1\$s äĹ֤ɬפǤäơȤߤޤ";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "򤵤EǥEȥȥեEιץ:";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "ѿE<b>consumption_ipaddress_datatransfer</b> ϿͤǤϤޤ";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "ʸ΁E<b>%1\$s</b> ϼΥեE˸Ĥޤ:";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "ʸ΁E<b>%1\$s</b> 򤵤EǥEȥȥեEˤϸĤޤǤ";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "̥եEϤǤFTPо <b>%1\$s</b> Ȥ¸EƤޤ";
$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "̥եE <b>%1\$s</b> Eޤ";
$net2ftp_messages["This SQL query is going to be executed:"] = " SQL꤬¹ԤE褦ȤƤޤ:";
$net2ftp_messages["This file is not accessible from the web"] = "ΥեE web夫饢ǤޤE;
$net2ftp_messages["This folder is empty"] = "ΥեE϶Ǥ";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "εǽϥȤδԤˤä̵ˤEƤޤ";
$net2ftp_messages["This function is available on PHP 5 only"] = "εǽ PHP 5 ǤΤͭǤ";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "This script runs on your web server and requires PHP to be installed.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "λ¤ϡͤʿ webФѤǤE褦ݾ㤹EΤǤ";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "ΥС net2ftp ϺǿΤΤǤ";
$net2ftp_messages["Time of sending: "] = "Time of sending: ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "EɤˤϡƤΥ֥饦ΥɥĤEפޤ";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "E¸EˤϡEξǱEå '̾դƲE¸...' 򤷤Ƥ";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "̤оݥǥEȥꤹEˤϡΥƥȥܥåоݥǥEȥϤ \"ƤоݥǥEȥ\" ܥ򥯥EåƲ";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\"";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "ƤεľƱͤˤEˤϡǵľϤ \"\" ܥ򥯥EåƤ";
$net2ftp_messages["To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now."] = "To use this applet, please install the newest version of Sun's java. You can get it from <a href=\"http://www.java.com/\">java.com</a>. Click on Get It Now.";
$net2ftp_messages["Transferring files to the FTP server"] = "եEEFTPФžƤޤ";
$net2ftp_messages["Transform selected entries: "] = "򤵤Eȥ: ";
$net2ftp_messages["Troubleshoot an FTP server"] = "FTPФΥȥ֥E塼";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "webФ net2ftp Υȥ֥E塼";
$net2ftp_messages["Troubleshoot your net2ftp installation"] = "ʤ net2ftp Ƴȥ֥E塼";
$net2ftp_messages["Troubleshooting functions"] = "ȥ֥E塼ƥ󥰵ǽ";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Ȥ褁EʺȤʬ䤷ƤߤƲ: եE¤礭ʥեEʤƤ";
$net2ftp_messages["Two click access (net2ftp will ask for a password - safer)"] = "Two click access (net2ftp will ask for a password - safer)";
$net2ftp_messages["Type"] = "";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "ƥݥ饁EեEĤEȤǤޤE;
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP <b>%1\$s</b> Υݡ <b>%2\$s</b> ³EȤǤޤ<br /><br />ΥɥE FTP ΤΤǤ? EāEHTTP (web) ФΤΤȤϰۤʤäƤޤʤ ISPΥݡȥǥ ޤ ƥ 䤤礁EƤ<br />";
$net2ftp_messages["Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to connect to SSH server <b>%1\$s</b> on port <b>%2\$s</b> (%3\$s).<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "եE<b>%1\$s</b> 򥳥ԡEȤǤޤE;
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "FTP⡼ <b>%2\$s</b> ѤƥEեEE⡼ȥեE<b>%1\$s</b> ˥ԡEȤǤޤE;
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "FTP⡼ <b>%2\$s</b> ѤƥE⡼ȥեE<b>%1\$s</b> EեE˥ԡEȤǤޤE;
$net2ftp_messages["Unable to create a temporary directory (too many tries)"] = "Unable to create a temporary directory (too many tries)";
$net2ftp_messages["Unable to create a temporary directory because (parent directory is not writeable)"] = "Unable to create a temporary directory because (parent directory is not writeable)";
$net2ftp_messages["Unable to create a temporary directory because (unvalid parent directory)"] = "Unable to create a temporary directory because (unvalid parent directory)";
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "ǥEȥE<b>%1\$s</b> κܮϤǤޤE;
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "֥ǥEȥE<b>%1\$s</b> ϤǤ¸ߤEᡢܮEȤǤޤ󡣥ԡư³ޤ...";
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "ƥݥ饁EեEκܮԤޤ󡣥ǥEȥE%1\$s εľǧƤ";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "եE<b>%1\$s</b> EEEȤǤޤE;
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "ǥEȥE<b>%1\$s</b> ϺEEǤޤE;
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "եE<b>%1\$s</b> ϺEEǤޤE;
$net2ftp_messages["Unable to delete the local file"] = "EեEEEEȤǤޤE;
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "֥ǥEȥE<b>%1\$s</b> EEEȤǤޤE- ΥǥEȥ϶ǤϤޤE;
$net2ftp_messages["Unable to delete the temporary directory"] = "Unable to delete the temporary directory";
$net2ftp_messages["Unable to delete the temporary file"] = "ƥݥ饁EեEEEEȤǤޤE;
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Unable to delete the temporary file %1\$s";
$net2ftp_messages["Unable to determine your IP address."] = "ʤ IPɥEȽ̤EȤǤޤ";
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "ȥޥ <b>%1\$s</b> ¹ԤEȤǤޤE;
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "ȥޥ<b>%1\$s</b> ϼ¹ԤǤޤCHMOD ޥɤ Windows FTPФǤϤʤ Unix FTPФǤΤͭǤEȤդƤ";
$net2ftp_messages["Unable to execute the SQL query."] = "SQL¹ԤEȤǤޤ";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Unable to extract the files and directories from the archive";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Unable to get the archive <b>%1\$s</b> from the FTP server";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "FTP եE<b>%1\$s</b>  EեE<b>%2\$s</b> Ȥ¸EȤǤޤ<br />ǥEȥE%3\$s εľǧƤ<br />";
$net2ftp_messages["Unable to get the list of packages"] = "Unable to get the list of packages";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP <b>%1\$s</b> ˥桼̾ <b>%2\$s</b> ǥ󤹤EȤǤޤ<br /><br />ʤΥ桼̾ȥѥEɤǤ? ʤ ISPΥݡȥǥ ޤ ƥ 䤤礁EƤ<br />";
$net2ftp_messages["Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Unable to login to SSH server <b>%1\$s</b> with username <b>%2\$s</b> (%3\$s).<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />";
$net2ftp_messages["Unable to move the directory <b>%1\$s</b>"] = "Unable to move the directory <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>"] = "Unable to move the file <b>%1\$s</b>";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Unable to move the file <b>%1\$s</b>, aborting the move";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "åץɤեEƥݥ饁EǥEȥذưEȤǤޤ<br /><br />ΥȤδԤ net2ftp  /temp ǥEȥεľE<b>777</b> ꤹEפޤ";
$net2ftp_messages["Unable to open the system log."] = "Unable to open the system log.";
$net2ftp_messages["Unable to open the template file"] = "ƥץEȥեEޤE;
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "ƥݥ饁EեE򳫤ȤǤޤ󡣥ǥEȥE%1\$s εľǧƤ";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "FTPо˥եE<b>%1\$s</b> ֤ȤǤޤ<br />ǥEȥؤν񤭹ߵĤޤ";
$net2ftp_messages["Unable to read the template file"] = "ƥץEȥեEɤ߹ޤE;
$net2ftp_messages["Unable to read the temporary file"] = "ƥݥ饁EեEɤ߹ळȤǤޤE;
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "ǥEȥʤޤϥեEˤ̾E<b>%1\$s</b> E<b>%2\$s</b> ѹǤޤE;
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";
$net2ftp_messages["Unable to send the file to the browser"] = "եE֥饦EȤǤޤE;
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "FTP <b>%1\$s</b> Υѥå֥⡼ɤڤEؤEȤǤޤ";
$net2ftp_messages["Unable to write a message to the system log."] = "Unable to write a message to the system log.";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "ƥݥ饁EեE<b>%1\$s</b> ˽񤭹ळȤǤޤ<br />ǥEȥE%2\$s εľǧƤ";
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "ͽEʤơʸE %1\$s λޤ";
$net2ftp_messages["Unrecognized FTP output"] = " FTP ";
$net2ftp_messages["Unzip"] = "Unzip";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Unzip archive <b>%1\$s</b> to:";
$net2ftp_messages["Unzip archives"] = "Unzip archives";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Unzip the selected archives on the FTP server";
$net2ftp_messages["Up"] = "";
$net2ftp_messages["Update"] = "";
$net2ftp_messages["Upload"] = "åץ";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "СΥեE%1\$s 򥢥åץɤѹʬʻE;
$net2ftp_messages["Upload directories and files using a Java applet"] = "JavaץEåȤѤƥǥEȥȥեE򥢥åץ";
$net2ftp_messages["Upload files and archives"] = "եEȰ̥եEΥåץ";
$net2ftp_messages["Upload more files and archives"] = "¾ΥեEȰ̥եE⥢åץɤE;
$net2ftp_messages["Upload new files in directory %1\$s"] = "ǥEȥE%1\$s ˿եE򥢥åץ";
$net2ftp_messages["Upload to directory:"] = "åץΥǥEȥE";
$net2ftp_messages["Username"] = "桼̾";
$net2ftp_messages["Username is too long; please enter less than 255 characters."] = "Username is too long; please enter less than 255 characters.";
$net2ftp_messages["Version information"] = "СʁE;
$net2ftp_messages["View"] = "́E;
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Macromedia ShockWave Flash ࡼӡ %1\$s ɽ";
$net2ftp_messages["View file %1\$s"] = "եE%1\$s ɽ";
$net2ftp_messages["View image %1\$s"] = "E%1\$s ɽ";
$net2ftp_messages["View logs"] = "ɽ";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "եE%1\$s 򤢤ʤ HTTP webФɽ";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "եE%1\$s Υɤդɽ";
$net2ftp_messages["WAV sound file"] = "WAV ǥ";
$net2ftp_messages["Webmaster's email: "] = "Webmaster's email: ";
$net2ftp_messages["Writing some text to the file: "] = "եE˥ƥȤ񤭹Ǥޤ: ";
$net2ftp_messages["Wrong username or password. Please try again."] = "ä桼̾ѥEɤǤ䤁EƤ";
$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "̥եEΥեEϤEƤޤᤁE򥯥EåƥեEϤƲ";
$net2ftp_messages["You did not enter your Administrator username or password."] = "ԤΥ桼̾ѥEɤϤƤޤ";
$net2ftp_messages["You did not provide any file to upload."] = "åץɤEեEꤵEƤޤ";
$net2ftp_messages["You did not provide any text to send by email!"] = "Żҥ᡼EEåޤE";
$net2ftp_messages["You did not supply a From address."] = "пͥɥE̤ϤǤ";
$net2ftp_messages["You did not supply a To address."] = "襢ɥE̤ϤǤ";
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "ʤIPɥE(%1\$s)ϡػߤEIPɥEΥEȤäƤޤ";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Your IP address (%1\$s) is not in the list of allowed IP addresses.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your browser does not support applets, or you have disabled applets in your browser settings."] = "Your browser does not support applets, or you have disabled applets in your browser settings.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "ʤΥEȥǥEȥE<b>%1\$s</b> ¸ߤʤ򤹤EȤǤޤ";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your task was stopped"] = "Ȥߤޤ";
$net2ftp_messages["Zip"] = "";
$net2ftp_messages["Zip archive"] = "Zip ";
$net2ftp_messages["Zip entries"] = "̥եEȥE;
$net2ftp_messages["Zip the selected entries to save or email them"] = "򤵤Eȥ򰵽";
$net2ftp_messages["en"] = "ja";
$net2ftp_messages["files which were last modified"] = "եEκǽƁEǻāE;
$net2ftp_messages["files with a filename like"] = "եEāE;
$net2ftp_messages["files with a size"] = "եEāE;
$net2ftp_messages["from"] = "from";
$net2ftp_messages["iso-8859-1"] = "euc-jp";
$net2ftp_messages["left"] = "left";
$net2ftp_messages["ltr"] = "ltr";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp has tried to determine the directory mapping between the FTP server and the web server.";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com.";
$net2ftp_messages["no - please install it!"] = " - 󥹥ȡEƤ!";
$net2ftp_messages["not OK"] = "";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "ԡǥEȥE%1\$s εľǧƤ";
$net2ftp_messages["right"] = "right";
$net2ftp_messages["to"] = "to";
$net2ftp_messages["to:"] = "ƁE:";
$net2ftp_messages["yes"] = "Ϥ";

?>